/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.MonthDayIntegerType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.MonthDay;
import java.util.ArrayList;
import org.hibernate.Session;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLMonthDayIntegerTest
extends AbstractPostgreSQLIntegrationTest {
    public static final String COLUMN_TYPE = "integer";

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Season.class};
    }

    @Test
    public void testCreationAndFetchById() {
        Season season = this.createEntity("Summer", MonthDay.of(6, 21), MonthDay.of(9, 22));
        this.doInJPA(entityManager -> {
            Season summer = (Season)((Session)entityManager.unwrap(Session.class)).find(Season.class, (Object)season.getId());
            Assert.assertEquals((Object)summer.getBeginningOfSeason(), (Object)MonthDay.of(6, 21));
            Assert.assertEquals((Object)summer.getEndOfSeason(), (Object)MonthDay.of(9, 22));
        });
        Assert.assertEquals((Object)COLUMN_TYPE, (Object)this.getColumnType("end_of_season"));
        Assert.assertEquals((Object)COLUMN_TYPE, (Object)this.getColumnType("beginning_of_season"));
    }

    @Test
    public void testFetchWithQuery() {
        this.createEntity("Winter", MonthDay.of(12, 21), MonthDay.of(3, 20));
        this.doInJPA(entityManager -> {
            Season seasonQ = (Season)entityManager.createQuery("select s from Season s where s.beginningOfSeason = :beginningOfSeason", Season.class).setParameter("beginningOfSeason", (Object)MonthDay.of(12, 21)).getSingleResult();
            Assert.assertEquals((Object)"Winter", (Object)seasonQ.getName());
        });
        Assert.assertEquals((Object)COLUMN_TYPE, (Object)this.getColumnType("end_of_season"));
        Assert.assertEquals((Object)COLUMN_TYPE, (Object)this.getColumnType("beginning_of_season"));
    }

    public Season createEntity(String name, MonthDay beginning, MonthDay end) {
        Season season = new Season();
        season.setName(name);
        season.setBeginningOfSeason(beginning);
        season.setEndOfSeason(end);
        this.doInJPA(entityManager -> entityManager.persist((Object)season));
        return season;
    }

    public String getColumnType(String column) {
        ArrayList results = new ArrayList(1);
        this.doInJPA(entityManager -> {
            Object result = entityManager.createNativeQuery("SELECT data_type FROM information_schema.columns WHERE \ntable_name = 'season' AND column_name = :column_name").setParameter("column_name", (Object)column).getSingleResult();
            results.add((String)result);
        });
        return (String)results.get(0);
    }

    @Entity(name="Season")
    @Table(name="season")
    public static class Season {
        @Id
        @GeneratedValue
        private Long id;
        private String name;
        @Type(value=MonthDayIntegerType.class)
        @Column(name="beginning_of_season", columnDefinition="integer")
        private MonthDay beginningOfSeason;
        @Type(value=MonthDayIntegerType.class)
        @Column(name="end_of_season", columnDefinition="integer")
        private MonthDay endOfSeason;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public MonthDay getBeginningOfSeason() {
            return this.beginningOfSeason;
        }

        public void setBeginningOfSeason(MonthDay beginningOfSeason) {
            this.beginningOfSeason = beginningOfSeason;
        }

        public MonthDay getEndOfSeason() {
            return this.endOfSeason;
        }

        public void setEndOfSeason(MonthDay endOfSeason) {
            this.endOfSeason = endOfSeason;
        }
    }
}

