/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.PostgreSQLLTreeType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.hibernate.util.transaction.JPATransactionFunction;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLLTreeTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Tree.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS ltree");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        super.init();
    }

    @Test
    public void test() {
        Tree treeWithNullPath = new Tree();
        treeWithNullPath.setId(1L);
        this.persist(treeWithNullPath);
        this.testFindById(treeWithNullPath.getId(), treeWithNullPath.getPath());
        Tree treeWithPath = new Tree();
        treeWithPath.setId(2L);
        treeWithPath.setPath("Top.Collections.Pictures.Astronomy.Stars");
        this.persist(treeWithPath);
        this.testFindById(treeWithPath.getId(), treeWithPath.getPath());
        this.testFindTreeByPath(treeWithPath.getPath(), treeWithPath);
    }

    private void persist(final Tree tree) {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                entityManager.persist((Object)tree);
                return null;
            }
        });
    }

    private void testFindById(final Long treeId, final String expectedPath) {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Tree tree = (Tree)entityManager.find(Tree.class, (Object)treeId);
                Assert.assertEquals((Object)expectedPath, (Object)tree.getPath());
                return null;
            }
        });
    }

    private void testFindTreeByPath(final String searchablePath, final Tree expectedTree) {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                CriteriaBuilder builder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteria = builder.createQuery(Tree.class);
                Root root = criteria.from(Tree.class);
                criteria.where((Expression)builder.equal((Expression)root.get("path"), (Object)searchablePath));
                List trees = entityManager.createQuery(criteria).getResultList();
                Assert.assertEquals((long)1L, (long)trees.size());
                Tree tree = (Tree)trees.iterator().next();
                Assert.assertEquals((Object)expectedTree.getId(), (Object)tree.getId());
                Assert.assertEquals((Object)expectedTree.getPath(), (Object)tree.getPath());
                return null;
            }
        });
    }

    @Table(name="tree")
    @Entity(name="Tree")
    public static class Tree {
        @Id
        private Long id;
        @Type(value=PostgreSQLLTreeType.class)
        @Column(columnDefinition="ltree")
        private String path;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

