/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.Inet;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLInetType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.Session;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLInetTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private Event _event;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void afterInit() {
        this.doInJDBC((Connection connection) -> {
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("CREATE INDEX ON event USING gist (ip inet_ops)");
            }
            catch (SQLException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        this._event = (Event)this.doInJPA(entityManager -> {
            entityManager.persist((Object)new Event());
            Event event = new Event();
            event.setIp("192.168.0.123/24");
            entityManager.persist((Object)event);
            return event;
        });
    }

    @Test
    public void testFindById() {
        Event updatedEvent = (Event)this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"192.168.0.123/24", (Object)event.getIp().getAddress());
            Assert.assertEquals((Object)"192.168.0.123", (Object)event.getIp().toInetAddress().getHostAddress());
            event.setIp("192.168.0.231/24");
            return event;
        });
        Assert.assertEquals((Object)"192.168.0.231/24", (Object)updatedEvent.getIp().getAddress());
    }

    @Test
    public void testJPQLQuery() {
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.createQuery("select e from Event e where    ip is not null", Event.class).getSingleResult();
            Assert.assertEquals((Object)"192.168.0.123/24", (Object)event.getIp().getAddress());
        });
    }

    @Test
    public void testNativeQuery() {
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.createNativeQuery("SELECT e.* FROM event e WHERE    e.ip && CAST(:network AS inet) = true", Event.class).setParameter("network", (Object)"192.168.0.1/24").getSingleResult();
            Assert.assertEquals((Object)"192.168.0.123/24", (Object)event.getIp().getAddress());
        });
    }

    @Test
    public void testJDBCQuery() {
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            session.doWork(connection -> {
                try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM Event e WHERE    e.ip && ?::inet = true");){
                    ps.setObject(1, "192.168.0.1/24");
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        Long id = rs.getLong(1);
                        String ip = rs.getString(2);
                        Assert.assertEquals((Object)"192.168.0.123/24", (Object)ip);
                    }
                }
            });
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        @GeneratedValue
        private Long id;
        @Type(value=PostgreSQLInetType.class)
        @Column(name="ip", columnDefinition="inet")
        private Inet ip;

        public Long getId() {
            return this.id;
        }

        public Inet getIp() {
            return this.ip;
        }

        public void setIp(String address) {
            this.ip = new Inet(address);
        }
    }
}

