/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.PostgreSQLEnumJdbcType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.annotations.JdbcType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PostgreSQLEnumJdbcTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("DROP TYPE post_status_info CASCADE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TYPE post_status_info AS ENUM ('PENDING', 'APPROVED', 'SPAM')");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Before
    public void setUp() {
        this.doInJPA(entityManager -> {
            Post post = new Post();
            post.setId(1L);
            post.setTitle("High-Performance Java Persistence");
            post.setStatus(PostStatus.PENDING);
            entityManager.persist((Object)post);
        });
    }

    @Test
    @Ignore(value="Fails because of https://github.com/vladmihalcea/hypersistence-utils/issues/532")
    public void test() {
        this.doInJPA(entityManager -> {
            Post post = (Post)entityManager.find(Post.class, (Object)1L);
            Assert.assertEquals((Object)((Object)PostStatus.PENDING), (Object)((Object)post.getStatus()));
        });
    }

    @Test
    @Ignore(value="Fails because of https://github.com/vladmihalcea/hypersistence-utils/issues/532")
    public void testTypedParameterValue() {
        this.doInJPA(entityManager -> entityManager.createQuery("SELECT a FROM Post a WHERE a.status = :paramValue", Post.class).setParameter("paramValue", (Object)PostStatus.APPROVED).getResultList());
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @Id
        private Long id;
        private String title;
        @Enumerated(value=EnumType.STRING)
        @Column(columnDefinition="post_status_info")
        @JdbcType(value=PostStatusJdbcType.class)
        private PostStatus status;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public PostStatus getStatus() {
            return this.status;
        }

        public void setStatus(PostStatus status) {
            this.status = status;
        }
    }

    public static enum PostStatus {
        PENDING,
        APPROVED,
        SPAM;


        public String toString() {
            return String.format("The %s enum is mapped to ordinal: %d", this.name(), this.ordinal());
        }
    }

    public static class PostStatusJdbcType
    extends PostgreSQLEnumJdbcType {
        public PostStatusJdbcType() {
            super("post_status_info");
        }
    }
}

