/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.PostgreSQLCITextType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.hibernate.util.transaction.JPATransactionFunction;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLCITextTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Country.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS citext");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        super.init();
    }

    @Test
    public void test() {
        Country countryWithNullName = new Country();
        countryWithNullName.setId(1L);
        this.persist(countryWithNullName);
        this.testFindById(countryWithNullName.getId(), countryWithNullName.getName());
        Country countryWithName = new Country();
        countryWithName.setId(2L);
        countryWithName.setName("Test");
        this.persist(countryWithName);
        this.testFindById(countryWithName.getId(), countryWithName.getName());
        this.testFindCountryByName(countryWithName.getName(), countryWithName);
        this.testFindCountryByName(countryWithName.getName().toUpperCase(), countryWithName);
        this.testFindCountryByName(countryWithName.getName().toLowerCase(), countryWithName);
    }

    private void persist(final Country country) {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                entityManager.persist((Object)country);
                return null;
            }
        });
    }

    private void testFindById(final Long countryId, final String expectedName) {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Country country = (Country)entityManager.find(Country.class, (Object)countryId);
                Assert.assertEquals((Object)expectedName, (Object)country.getName());
                return null;
            }
        });
    }

    private void testFindCountryByName(final String searchableName, final Country expectedCountry) {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                CriteriaBuilder builder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteria = builder.createQuery(Country.class);
                Root root = criteria.from(Country.class);
                criteria.where((Expression)builder.equal((Expression)root.get("name"), (Object)searchableName));
                List countries = entityManager.createQuery(criteria).getResultList();
                Assert.assertEquals((long)1L, (long)countries.size());
                Country country = (Country)countries.iterator().next();
                Assert.assertEquals((Object)expectedCountry.getId(), (Object)country.getId());
                Assert.assertEquals((Object)expectedCountry.getName(), (Object)country.getName());
                return null;
            }
        });
    }

    @Table(name="country")
    @Entity(name="Country")
    public static class Country {
        @Id
        private Long id;
        @Type(value=PostgreSQLCITextType.class)
        @Column(columnDefinition="citext")
        private String name;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

