/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.util.AbstractOracleIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.junit.Assert;
import org.junit.Test;

public class OracleBinaryFloatTest
extends AbstractOracleIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("978-9730228236");
            book.setTitle("High-Performance Java Persistence");
            book.setRating(Float.valueOf(1.234f));
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((double)1.234f, (double)book.getRating().floatValue(), (double)0.001);
        });
    }

    @Test
    public void testNull() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("123-456");
            book.setRating(null);
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"123-456");
            Assert.assertNull((Object)book.getRating());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        private String title;
        @Column(columnDefinition="binary_float")
        private Float rating;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Float getRating() {
            return this.rating;
        }

        public void setRating(Float rating) {
            this.rating = rating;
        }
    }
}

