/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.NullableCharacterType;
import io.hypersistence.utils.hibernate.util.AbstractTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class NullableCharacterTypeTest
extends AbstractTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        super.init();
        this.doInJDBC((Connection connection) -> {
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("INSERT INTO EVENT (ID, EVENT_TYPE) VALUES (1, 'abc')");
                statement.executeUpdate("INSERT INTO EVENT (ID, EVENT_TYPE) VALUES (2, '')");
                statement.executeUpdate("INSERT INTO EVENT (ID, EVENT_TYPE) VALUES (3, 'b')");
            }
            catch (SQLException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void test() {
        AtomicReference eventHolder = new AtomicReference();
        this.doInJPA(entityManager -> {
            List events = entityManager.createQuery("select e from Event e", Event.class).getResultList();
            for (Event event : events) {
                this.LOGGER.info("Event type: {}", (Object)event.getType());
            }
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        @GeneratedValue
        private Long id;
        @Type(value=NullableCharacterType.class)
        @Column(name="event_type")
        private Character type;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Character getType() {
            return this.type;
        }

        public void setType(Character type) {
            this.type = type;
        }
    }
}

