/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.YearMonthDateType;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.YearMonth;
import java.util.TimeZone;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class MySQLYearMonthDateTest
extends AbstractMySQLIntegrationTest {
    private TimeZone defaultTimeZone;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void afterInit() {
        this.defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/Athens"));
    }

    @Override
    public void destroy() {
        super.destroy();
        TimeZone.setDefault(this.defaultTimeZone);
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("978-9730228236");
            book.setTitle("High-Performance Java Persistence");
            book.setPublishedOn(YearMonth.of(2016, 10));
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((Object)YearMonth.of(2016, 10), (Object)book.getPublishedOn());
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)entityManager.createQuery("select b from Book b where    b.title = :title and    b.publishedOn = :publishedOn", Book.class).setParameter("title", (Object)"High-Performance Java Persistence").setParameter("publishedOn", (Object)YearMonth.of(2016, 10)).getSingleResult();
            Assert.assertEquals((Object)"978-9730228236", (Object)book.getIsbn());
        });
    }

    @Test
    public void testNull() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("123-456");
            book.setPublishedOn(null);
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"123-456");
            Assert.assertNull((Object)book.getPublishedOn());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        private String title;
        @Type(value=YearMonthDateType.class)
        @Column(name="published_on", columnDefinition="date")
        private YearMonth publishedOn;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public YearMonth getPublishedOn() {
            return this.publishedOn;
        }

        public void setPublishedOn(YearMonth publishedOn) {
            this.publishedOn = publishedOn;
        }
    }
}

