/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.DoubleArrayType;
import io.hypersistence.utils.hibernate.type.array.FloatArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.LongArrayType;
import io.hypersistence.utils.hibernate.type.array.UUIDArrayType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.junit.Assert;
import org.junit.Test;

public class WrapperArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\"");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorIds(new UUID[]{UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")});
            event.setSensorValues(new Integer[]{12, 756});
            event.setSensorLongValues(new Long[]{42L, 0x7FFFFFFFFFFFFFF8L});
            event.setSensorDoubleValues(new Double[]{0.123, 456.789});
            event.setSensorFloatValues(new Float[]{Float.valueOf(1.23f), Float.valueOf(45.89f)});
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[]{UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")}, (Object[])event.getSensorIds());
            Assert.assertArrayEquals((Object[])new Integer[]{12, 756}, (Object[])event.getSensorValues());
            Assert.assertArrayEquals((Object[])new Long[]{42L, 0x7FFFFFFFFFFFFFF8L}, (Object[])event.getSensorLongValues());
            Assert.assertArrayEquals((Object[])new Double[]{0.123, 456.789}, (Object[])event.getSensorDoubleValues());
            Assert.assertArrayEquals((Object[])new Float[]{Float.valueOf(1.23f), Float.valueOf(45.89f)}, (Object[])event.getSensorFloatValues());
        });
        this.doInJPA(entityManager -> {
            List events = ((NativeQuery)entityManager.createNativeQuery("select    id,    sensor_ids,    sensor_values,    sensor_double_values,      sensor_float_values   from event ", Tuple.class).unwrap(NativeQuery.class)).addScalar("sensor_ids", UUID[].class).addScalar("sensor_values", int[].class).addScalar("sensor_double_values", double[].class).addScalar("sensor_float_values", float[].class).getResultList();
            Assert.assertEquals((long)2L, (long)events.size());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=UUIDArrayType.class)
        @Column(name="sensor_ids", columnDefinition="uuid[]")
        private UUID[] sensorIds;
        @Type(value=IntArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private Integer[] sensorValues;
        @Type(value=LongArrayType.class)
        @Column(name="sensor_long_values", columnDefinition="bigint[]")
        private Long[] sensorLongValues;
        @Type(value=DoubleArrayType.class)
        @Column(name="sensor_double_values", columnDefinition="float8[]")
        private Double[] sensorDoubleValues;
        @Type(value=FloatArrayType.class)
        @Column(name="sensor_float_values", columnDefinition="float4[]")
        private Float[] sensorFloatValues;

        public UUID[] getSensorIds() {
            return this.sensorIds;
        }

        public void setSensorIds(UUID[] sensorIds) {
            this.sensorIds = sensorIds;
        }

        public Integer[] getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(Integer[] sensorValues) {
            this.sensorValues = sensorValues;
        }

        public Long[] getSensorLongValues() {
            return this.sensorLongValues;
        }

        public void setSensorLongValues(Long[] sensorLongValues) {
            this.sensorLongValues = sensorLongValues;
        }

        public Double[] getSensorDoubleValues() {
            return this.sensorDoubleValues;
        }

        public void setSensorDoubleValues(Double[] sensorDoubleValues) {
            this.sensorDoubleValues = sensorDoubleValues;
        }

        public Float[] getSensorFloatValues() {
            return this.sensorFloatValues;
        }

        public void setSensorFloatValues(Float[] sensorFloatValues) {
            this.sensorFloatValues = sensorFloatValues;
        }
    }
}

