/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class SimpleArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("DROP TYPE sensor_state CASCADE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TYPE sensor_state AS ENUM ('ONLINE', 'OFFLINE', 'UNKNOWN')");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            entityManager.persist((Object)new Event().setId(1L).setSensorNames(new String[]{"Temperature", "Pressure"}).setSensorValues(new int[]{12, 756}).setSensorStates(new SensorState[]{SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN}));
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", "Pressure"}, (Object[])event.getSensorNames());
            Assert.assertArrayEquals((int[])new int[]{12, 756}, (int[])event.getSensorValues());
            Assert.assertArrayEquals((Object[])new SensorState[]{SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN}, (Object[])event.getSensorStates());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        private Long id;
        @Type(value=StringArrayType.class)
        @Column(name="sensor_names", columnDefinition="text[]")
        private String[] sensorNames;
        @Type(value=IntArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private int[] sensorValues;
        @Type(value=EnumArrayType.class, parameters={@Parameter(name="sql_array_type", value="sensor_state")})
        @Column(name="sensor_states", columnDefinition="sensor_state[]")
        private SensorState[] sensorStates;

        public Long getId() {
            return this.id;
        }

        public Event setId(Long id) {
            this.id = id;
            return this;
        }

        public String[] getSensorNames() {
            return this.sensorNames;
        }

        public Event setSensorNames(String[] sensorNames) {
            this.sensorNames = sensorNames;
            return this;
        }

        public int[] getSensorValues() {
            return this.sensorValues;
        }

        public Event setSensorValues(int[] sensorValues) {
            this.sensorValues = sensorValues;
            return this;
        }

        public SensorState[] getSensorStates() {
            return this.sensorStates;
        }

        public Event setSensorStates(SensorState[] sensorStates) {
            this.sensorStates = sensorStates;
            return this;
        }
    }

    public static enum SensorState {
        ONLINE,
        OFFLINE,
        UNKNOWN;

    }
}

