/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PostgreSQLMultipleEnumArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{UserAccount.class};
    }

    @Override
    @Before
    public void init() {
        Statement statement;
        Connection connection;
        DataSource dataSource = this.newDataSource();
        try {
            connection = dataSource.getConnection();
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("DROP TYPE IF EXISTS user_role;");
                    statement.executeUpdate("CREATE TYPE user_role AS ENUM ('ROLE_ADMIN', 'ROLE_USER');");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            connection = dataSource.getConnection();
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("DROP TYPE IF EXISTS user_role;");
                    statement.executeUpdate("CREATE TYPE user_role AS ENUM ('ROLE_ADMIN', 'ROLE_USER');");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("DROP TYPE IF EXISTS user_type;");
                    statement.executeUpdate("CREATE TYPE user_type AS ENUM ('SUPER_USER', 'REGULAR');");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void test() {
        UserRole[] userRoles = new UserRole[]{UserRole.ROLE_ADMIN, UserRole.ROLE_USER};
        UserType[] userTypes = new UserType[]{UserType.SUPER_USER, UserType.REGULAR};
        this.doInJPA(entityManager -> {
            UserAccount account = new UserAccount();
            account.setUsername("vladmihalcea.com");
            account.setRoles(userRoles);
            account.setTypes(userTypes);
            entityManager.persist((Object)account);
        });
        this.doInJPA(entityManager -> {
            UserAccount singleResult = (UserAccount)entityManager.createQuery("select ua from UserAccountEntity ua where ua.username = :username", UserAccount.class).setParameter("username", (Object)"vladmihalcea.com").getSingleResult();
            Assert.assertArrayEquals((Object[])userRoles, (Object[])singleResult.getRoles());
            Assert.assertArrayEquals((Object[])userTypes, (Object[])singleResult.getTypes());
        });
    }

    @Entity(name="UserAccountEntity")
    @Table(name="users")
    public static class UserAccount {
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        private Long id;
        private String username;
        @Type(value=EnumArrayType.class, parameters={@Parameter(name="sql_array_type", value="user_role")})
        @Column(name="roles", columnDefinition="user_role[]")
        private UserRole[] roles;
        @Type(value=EnumArrayType.class, parameters={@Parameter(name="sql_array_type", value="user_type")})
        @Column(name="types", columnDefinition="user_type[]")
        private UserType[] types;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public UserRole[] getRoles() {
            return this.roles;
        }

        public void setRoles(UserRole[] roles) {
            this.roles = roles;
        }

        public UserType[] getTypes() {
            return this.types;
        }

        public void setTypes(UserType[] types) {
            this.types = types;
        }
    }

    public static enum UserRole {
        ROLE_ADMIN,
        ROLE_USER;

    }

    public static enum UserType {
        SUPER_USER,
        REGULAR;

    }
}

