/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.query.TypedParameterValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PostgreSQLEnumArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    public static final EnumArrayType ROLE_TYPE = new EnumArrayType(UserRole.class, "user_role");

    @Override
    protected Class<?>[] entities() {
        return new Class[]{UserAccount.class};
    }

    @Override
    @Before
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("DROP TYPE IF EXISTS user_role;");
            statement.executeUpdate("CREATE TYPE user_role AS ENUM ('ROLE_ADMIN', 'ROLE_USER');");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void test() {
        UserRole[] userRoles = new UserRole[]{UserRole.ROLE_ADMIN, UserRole.ROLE_USER};
        this.doInJPA(entityManager -> {
            UserAccount account = new UserAccount();
            account.setUsername("vladmihalcea.com");
            account.setRoles(userRoles);
            entityManager.persist((Object)account);
        });
        this.doInJPA(entityManager -> {
            UserAccount singleResult = (UserAccount)entityManager.createQuery("select ua from UserAccountEntity ua where ua.username = :username", UserAccount.class).setParameter("username", (Object)"vladmihalcea.com").getSingleResult();
            Assert.assertArrayEquals((Object[])userRoles, (Object[])singleResult.getRoles());
        });
    }

    @Test
    public void testSetParameterWithType() {
        UserRole[] userRoles = new UserRole[]{UserRole.ROLE_ADMIN, UserRole.ROLE_USER};
        UserRole[] requiredRoles = new UserRole[]{UserRole.ROLE_USER};
        this.doInJPA(entityManager -> {
            UserAccount account = new UserAccount();
            account.setUsername("vladmihalcea.com");
            account.setRoles(userRoles);
            entityManager.persist((Object)account);
        });
        this.doInJPA(entityManager -> ((Query)entityManager.createQuery("select ua from UserAccountEntity ua where ua.roles = :roles", UserAccount.class).unwrap(Query.class)).setParameter("roles", (Object)requiredRoles, (BindableType)new EnumArrayType(UserRole[].class, "user_role")).getResultList());
    }

    @Test
    public void testTypedParameterValue() {
        UserRole[] userRoles = new UserRole[]{UserRole.ROLE_ADMIN, UserRole.ROLE_USER};
        UserRole[] requiredRoles = new UserRole[]{UserRole.ROLE_USER};
        this.doInJPA(entityManager -> {
            UserAccount account = new UserAccount();
            account.setUsername("vladmihalcea.com");
            account.setRoles(userRoles);
            entityManager.persist((Object)account);
        });
        this.doInJPA(entityManager -> entityManager.createQuery("select ua from UserAccountEntity ua where ua.roles = :roles", UserAccount.class).setParameter("roles", (Object)new TypedParameterValue((BindableType)new EnumArrayType(UserRole[].class, "user_role"), (Object)requiredRoles)).getResultList());
    }

    @Entity(name="UserAccountEntity")
    @Table(name="users")
    public static class UserAccount {
        @Id
        @GeneratedValue
        private Long id;
        private String username;
        @Type(value=EnumArrayType.class, parameters={@Parameter(name="sql_array_type", value="user_role")})
        @Column(name="roles", columnDefinition="user_role[]")
        private UserRole[] roles;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public UserRole[] getRoles() {
            return this.roles;
        }

        public void setRoles(UserRole[] roles) {
            this.roles = roles;
        }
    }

    public static enum UserRole {
        ROLE_ADMIN,
        ROLE_USER;

    }
}

