/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.MultiDimensionalArrayTypeTest;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class MultiDimensionalStringArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Plane.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new EnumArrayType(ReflectionUtils.getField(MultiDimensionalArrayTypeTest.Plane.class, (String)"seatGrid").getClass(), "seat_status"))));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Plane().setId(1L).setName("ATR-42").setSeatGrid(new String[][]{{"BLOCKED", "BLOCKED", "BLOCKED", "BLOCKED"}, {"UNRESERVED", "UNRESERVED", "RESERVED", "UNRESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"RESERVED", "RESERVED", "RESERVED", "RESERVED"}, {"BLOCKED", "BLOCKED", "BLOCKED", "BLOCKED"}})));
        this.doInJPA(entityManager -> {
            Plane plane = (Plane)entityManager.find(Plane.class, (Object)1L);
            Assert.assertEquals((Object)"ATR-42", (Object)plane.getName());
            Assert.assertEquals((Object)"BLOCKED", (Object)plane.getSeatStatus(1, 'A'));
            Assert.assertEquals((Object)"BLOCKED", (Object)plane.getSeatStatus(1, 'B'));
            Assert.assertEquals((Object)"BLOCKED", (Object)plane.getSeatStatus(1, 'C'));
            Assert.assertEquals((Object)"BLOCKED", (Object)plane.getSeatStatus(1, 'D'));
            Assert.assertEquals((Object)"UNRESERVED", (Object)plane.getSeatStatus(2, 'A'));
            Assert.assertEquals((Object)"UNRESERVED", (Object)plane.getSeatStatus(2, 'B'));
            Assert.assertEquals((Object)"RESERVED", (Object)plane.getSeatStatus(2, 'C'));
            Assert.assertEquals((Object)"UNRESERVED", (Object)plane.getSeatStatus(2, 'D'));
        });
        this.doInJPA(entityManager -> {
            List tuples = ((NativeQuery)entityManager.createNativeQuery("SELECT    id,    name,    seat_grid FROM plane WHERE id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("id").addScalar("name").addScalar("seat_grid", ReflectionUtils.getField(MultiDimensionalArrayTypeTest.Plane.class, (String)"seatGrid").getClass()).getResultList();
            Tuple plane = (Tuple)tuples.get(0);
            Assert.assertEquals((Object)"ATR-42", (Object)plane.get("name"));
        });
    }

    @Entity(name="Plane")
    @Table(name="plane")
    public static class Plane {
        @Id
        private Long id;
        private String name;
        @Type(value=StringArrayType.class)
        @Column(name="seat_grid", columnDefinition="text[][]")
        private String[][] seatGrid;

        public Long getId() {
            return this.id;
        }

        public Plane setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Plane setName(String name) {
            this.name = name;
            return this;
        }

        public String[][] getSeatGrid() {
            return this.seatGrid;
        }

        public Plane setSeatGrid(String[][] seatGrid) {
            this.seatGrid = seatGrid;
            return this;
        }

        public String getSeatStatus(int row, char letter) {
            return this.seatGrid[row - 1][letter - 65];
        }
    }
}

