/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.MultiDimensionalArrayTypeTest;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class MultiDimensionalIntegerArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Plane.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new EnumArrayType(ReflectionUtils.getField(MultiDimensionalArrayTypeTest.Plane.class, (String)"seatGrid").getClass(), "seat_status"))));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Plane().setId(1L).setName("ATR-42").setSeatGrid(new Integer[][]{{1, 1, 1, 1}, {0, 0, 2, 0}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {2, 2, 2, 2}, {1, 1, 1, 1}})));
        this.doInJPA(entityManager -> {
            Plane plane = (Plane)entityManager.find(Plane.class, (Object)1L);
            Assert.assertEquals((Object)"ATR-42", (Object)plane.getName());
            Assert.assertEquals((long)1L, (long)plane.getSeatStatus(1, 'A'));
            Assert.assertEquals((long)1L, (long)plane.getSeatStatus(1, 'B'));
            Assert.assertEquals((long)1L, (long)plane.getSeatStatus(1, 'C'));
            Assert.assertEquals((long)1L, (long)plane.getSeatStatus(1, 'D'));
            Assert.assertEquals((long)0L, (long)plane.getSeatStatus(2, 'A'));
            Assert.assertEquals((long)0L, (long)plane.getSeatStatus(2, 'B'));
            Assert.assertEquals((long)2L, (long)plane.getSeatStatus(2, 'C'));
            Assert.assertEquals((long)0L, (long)plane.getSeatStatus(2, 'D'));
        });
        this.doInJPA(entityManager -> {
            List tuples = ((NativeQuery)entityManager.createNativeQuery("SELECT    id,    name,    seat_grid FROM plane WHERE id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("id").addScalar("name").addScalar("seat_grid", ReflectionUtils.getField(MultiDimensionalArrayTypeTest.Plane.class, (String)"seatGrid").getClass()).getResultList();
            Tuple plane = (Tuple)tuples.get(0);
            Assert.assertEquals((Object)"ATR-42", (Object)plane.get("name"));
        });
    }

    @Entity(name="Plane")
    @Table(name="plane")
    public static class Plane {
        @Id
        private Long id;
        private String name;
        @Type(value=IntArrayType.class)
        @Column(name="seat_grid", columnDefinition="int[][]")
        private Integer[][] seatGrid;

        public Long getId() {
            return this.id;
        }

        public Plane setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Plane setName(String name) {
            this.name = name;
            return this;
        }

        public Integer[][] getSeatGrid() {
            return this.seatGrid;
        }

        public Plane setSeatGrid(Integer[][] seatGrid) {
            this.seatGrid = seatGrid;
            return this;
        }

        public int getSeatStatus(int row, char letter) {
            return this.seatGrid[row - 1][letter - 65];
        }
    }
}

