/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiDimensionalArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Plane.class};
    }

    @Override
    @Before
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("DROP TABLE IF EXISTS plane;");
            statement.executeUpdate("DROP TYPE IF EXISTS seat_status CASCADE;");
            statement.executeUpdate("CREATE TYPE seat_status AS ENUM ('UNRESERVED', 'RESERVED', 'BLOCKED');");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new EnumArrayType(ReflectionUtils.getField(Plane.class, (String)"seatGrid").getClass(), "seat_status"))));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Plane().setId(1L).setName("ATR-42").setSeatGrid(new SeatStatus[][]{{SeatStatus.BLOCKED, SeatStatus.BLOCKED, SeatStatus.BLOCKED, SeatStatus.BLOCKED}, {SeatStatus.UNRESERVED, SeatStatus.UNRESERVED, SeatStatus.RESERVED, SeatStatus.UNRESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED, SeatStatus.RESERVED}, {SeatStatus.BLOCKED, SeatStatus.BLOCKED, SeatStatus.BLOCKED, SeatStatus.BLOCKED}})));
        this.doInJPA(entityManager -> {
            Plane plane = (Plane)entityManager.find(Plane.class, (Object)1L);
            Assert.assertEquals((Object)"ATR-42", (Object)plane.getName());
            Assert.assertEquals((Object)((Object)SeatStatus.BLOCKED), (Object)((Object)plane.getSeatStatus(1, 'A')));
            Assert.assertEquals((Object)((Object)SeatStatus.BLOCKED), (Object)((Object)plane.getSeatStatus(1, 'B')));
            Assert.assertEquals((Object)((Object)SeatStatus.BLOCKED), (Object)((Object)plane.getSeatStatus(1, 'C')));
            Assert.assertEquals((Object)((Object)SeatStatus.BLOCKED), (Object)((Object)plane.getSeatStatus(1, 'D')));
            Assert.assertEquals((Object)((Object)SeatStatus.UNRESERVED), (Object)((Object)plane.getSeatStatus(2, 'A')));
            Assert.assertEquals((Object)((Object)SeatStatus.UNRESERVED), (Object)((Object)plane.getSeatStatus(2, 'B')));
            Assert.assertEquals((Object)((Object)SeatStatus.RESERVED), (Object)((Object)plane.getSeatStatus(2, 'C')));
            Assert.assertEquals((Object)((Object)SeatStatus.UNRESERVED), (Object)((Object)plane.getSeatStatus(2, 'D')));
        });
        this.doInJPA(entityManager -> {
            List tuples = ((NativeQuery)entityManager.createNativeQuery("SELECT    id,    name,    seat_grid FROM plane WHERE id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("id").addScalar("name").addScalar("seat_grid", ReflectionUtils.getField(Plane.class, (String)"seatGrid").getClass()).getResultList();
            Tuple plane = (Tuple)tuples.get(0);
            Assert.assertEquals((Object)"ATR-42", (Object)plane.get("name"));
        });
    }

    @Entity(name="Plane")
    @Table(name="plane")
    public static class Plane {
        @Id
        private Long id;
        private String name;
        @Type(value=EnumArrayType.class, parameters={@Parameter(name="sql_array_type", value="seat_status")})
        @Column(name="seat_grid", columnDefinition="seat_status[][]")
        private SeatStatus[][] seatGrid;

        public Long getId() {
            return this.id;
        }

        public Plane setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Plane setName(String name) {
            this.name = name;
            return this;
        }

        public SeatStatus[][] getSeatGrid() {
            return this.seatGrid;
        }

        public Plane setSeatGrid(SeatStatus[][] seatGrid) {
            this.seatGrid = seatGrid;
            return this;
        }

        public SeatStatus getSeatStatus(int row, char letter) {
            return this.seatGrid[row - 1][letter - 65];
        }
    }

    public static enum SeatStatus {
        UNRESERVED,
        RESERVED,
        BLOCKED;

    }
}

