/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class MatrixArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Test
    public void testNonEmptyArray() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            entityManager.persist((Object)new Event().setId(1L).setMatrix(new String[][]{{"A", "B", "C"}, {"1", "2", "3"}}));
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new String[][]{{"A", "B", "C"}, {"1", "2", "3"}}, (Object[])event.getMatrix());
        });
    }

    @Test
    public void testEmptyArray() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            entityManager.persist((Object)new Event().setId(1L).setMatrix(new String[0][]));
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new String[0][], (Object[])event.getMatrix());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        private Long id;
        @Type(value=StringArrayType.class)
        @Column(name="test_2d_array", columnDefinition="text[]")
        private String[][] matrix;

        public Long getId() {
            return this.id;
        }

        public Event setId(Long id) {
            this.id = id;
            return this;
        }

        public String[][] getMatrix() {
            return this.matrix;
        }

        public Event setMatrix(String[][] matrix) {
            this.matrix = matrix;
            return this;
        }
    }
}

