/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.ListArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Table;
import java.util.Arrays;
import java.util.List;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class MappedSuperclassListArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorNames(Arrays.asList("Temperature", "Pressure"));
            event.setSensorValues(Arrays.asList(12, 756));
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", "Pressure"}, (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[]{12, 756}, (Object[])event.getSensorValues().toArray());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=ListArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private List<Integer> sensorValues;

        public List<Integer> getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(List<Integer> sensorValues) {
            this.sensorValues = sensorValues;
        }
    }

    @MappedSuperclass
    public static class BaseEntity {
        @Id
        private Long id;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_names", columnDefinition="text[]")
        private List<String> sensorNames;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public List<String> getSensorNames() {
            return this.sensorNames;
        }

        public void setSensorNames(List<String> sensorNames) {
            this.sensorNames = sensorNames;
        }
    }
}

