/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.ListArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class ListArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("DROP TYPE sensor_state CASCADE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TYPE sensor_state AS ENUM ('ONLINE', 'OFFLINE', 'UNKNOWN')");
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\"");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new EnumArrayType(SensorState[].class, "sensor_state"))));
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            entityManager.persist((Object)new Event().setId(0L));
            entityManager.persist((Object)new Event().setId(1L).setSensorIds(Arrays.asList(UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800"))).setSensorNames(Arrays.asList("Temperature", "Pressure")).setSensorValues(Arrays.asList(12, 756)).setSensorLongValues(Arrays.asList(42L, 0x7FFFFFFFFFFFFFF8L)).setSensorBooleanValues(Arrays.asList(true, false)).setSensorDoubleValues(Arrays.asList(0.123, 456.789)).setSensorStates(Arrays.asList(SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN)).setDateValues(Arrays.asList(Date.valueOf(LocalDate.of(1991, 12, 31)), Date.valueOf(LocalDate.of(1990, 1, 1)))).setTimestampValues(Arrays.asList(java.util.Date.from(LocalDate.of(1991, 12, 31).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), java.util.Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()))).setDecimalValues(Arrays.asList(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.TEN)).setLocalDateValues(Arrays.asList(LocalDate.of(2022, 3, 22), LocalDate.of(2021, 4, 21))).setLocalDateTimeValues(Arrays.asList(LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2021, 4, 21, 22, 33, 44))).setLocalDateTimeSetValues(new LinkedHashSet<LocalDateTime>(Arrays.asList(LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2021, 4, 21, 22, 33, 44)))));
        });
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertEquals(Arrays.asList(UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")), event.getSensorIds());
            Assert.assertEquals(Arrays.asList("Temperature", "Pressure"), event.getSensorNames());
            Assert.assertEquals(Arrays.asList(12, 756), event.getSensorValues());
            Assert.assertEquals(Arrays.asList(42L, 0x7FFFFFFFFFFFFFF8L), event.getSensorLongValues());
            Assert.assertEquals(Arrays.asList(true, false), event.getSensorBooleanValues());
            Assert.assertEquals(Arrays.asList(0.123, 456.789), event.getSensorDoubleValues());
            Assert.assertEquals(Arrays.asList(SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN), event.getSensorStates());
            Assert.assertEquals(Arrays.asList(Date.valueOf(LocalDate.of(1991, 12, 31)), Date.valueOf(LocalDate.of(1990, 1, 1))), event.getDateValues());
            Assert.assertEquals(Arrays.asList(java.util.Date.from(LocalDate.of(1991, 12, 31).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), java.util.Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())), event.getTimestampValues());
            Assert.assertEquals(Arrays.asList(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.TEN), event.getDecimalValues());
            Assert.assertEquals(Arrays.asList(LocalDate.of(2022, 3, 22), LocalDate.of(2021, 4, 21)), event.getLocalDateValues());
            Assert.assertEquals(Arrays.asList(LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2021, 4, 21, 22, 33, 44)), event.getLocalDateTimeValues());
            Assert.assertEquals(new HashSet<LocalDateTime>(Arrays.asList(LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2021, 4, 21, 22, 33, 44))), event.getLocalDateTimeSetValues());
        });
        this.doInJPA(entityManager -> {
            List events = ((NativeQuery)entityManager.createNativeQuery("select    id,    sensor_ids,    sensor_names,    sensor_values from event where id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("sensor_ids", UUID[].class).addScalar("sensor_names", String[].class).addScalar("sensor_values", int[].class).getResultList();
            Assert.assertEquals((long)2L, (long)events.size());
        });
    }

    @Test
    public void testScalarEnumArray() {
        this.doInJPA(entityManager -> {
            List events = ((NativeQuery)entityManager.createNativeQuery("select    id,    sensor_ids,    sensor_names,    sensor_values,    sensor_states from event where id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("sensor_ids", UUID[].class).addScalar("sensor_names", String[].class).addScalar("sensor_values", int[].class).addScalar("sensor_states", SensorState[].class).getResultList();
            Assert.assertEquals((long)2L, (long)events.size());
        });
    }

    @Test
    public void testMixingNullValues() {
        java.util.Date date = java.util.Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(100L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(101L);
            event.setSensorIds(Arrays.asList(null, UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")));
            event.setSensorNames(Arrays.asList("Temperature", null));
            event.setSensorValues(Arrays.asList(null, 756));
            event.setSensorLongValues(Arrays.asList(null, 0x7FFFFFFFFFFFFFF8L));
            event.setSensorBooleanValues(Arrays.asList(null, false));
            event.setSensorDoubleValues(Arrays.asList(null, 456.789));
            event.setSensorStates(Arrays.asList(null, SensorState.OFFLINE, SensorState.ONLINE, null));
            event.setDateValues(Arrays.asList(null, date));
            event.setTimestampValues(Arrays.asList(null, date));
            event.setDecimalValues(Arrays.asList(null, BigDecimal.TEN));
            event.setLocalDateValues(Arrays.asList(null, LocalDate.of(2021, 4, 21)));
            event.setLocalDateTimeValues(Arrays.asList(null, LocalDateTime.of(2021, 4, 21, 22, 33, 44)));
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)101L);
            Assert.assertArrayEquals((Object[])new UUID[]{null, UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")}, (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", null}, (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[]{null, 756}, (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[]{null, 0x7FFFFFFFFFFFFFF8L}, (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new Boolean[]{null, false}, (Object[])event.getSensorBooleanValues().toArray());
            Assert.assertArrayEquals((Object[])new Double[]{null, 456.789}, (Object[])event.getSensorDoubleValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[]{null, SensorState.OFFLINE, SensorState.ONLINE, null}, (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new java.util.Date[]{null, date}, (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new java.util.Date[]{null, date}, (Object[])event.getTimestampValues().toArray());
            Assert.assertArrayEquals((Object[])new BigDecimal[]{null, BigDecimal.TEN}, (Object[])event.getDecimalValues().toArray());
            Assert.assertArrayEquals((Object[])new LocalDate[]{null, LocalDate.of(2021, 4, 21)}, (Object[])event.getLocalDateValues().toArray());
            Assert.assertArrayEquals((Object[])new LocalDateTime[]{null, LocalDateTime.of(2021, 4, 21, 22, 33, 44)}, (Object[])event.getLocalDateTimeValues().toArray());
        });
    }

    @Test
    public void testNullValues() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(100L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(101L);
            event.setSensorIds(Arrays.asList(null, null));
            event.setSensorNames(Arrays.asList(null, null));
            event.setSensorValues(Arrays.asList(null, null));
            event.setSensorLongValues(Arrays.asList(null, null));
            event.setSensorBooleanValues(Arrays.asList(null, null));
            event.setSensorDoubleValues(Arrays.asList(null, null));
            event.setSensorStates(Arrays.asList(null, null));
            event.setDateValues(Arrays.asList(null, null));
            event.setTimestampValues(Arrays.asList(null, null));
            event.setDecimalValues(Arrays.asList(null, null));
            event.setLocalDateValues(Arrays.asList(null, null));
            event.setLocalDateTimeValues(Arrays.asList(null, null));
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)101L);
            Assert.assertArrayEquals((Object[])new UUID[]{null, null}, (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[]{null, null}, (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[]{null, null}, (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new Boolean[]{null, null}, (Object[])event.getSensorBooleanValues().toArray());
            Assert.assertArrayEquals((Object[])new Double[]{null, null}, (Object[])event.getSensorDoubleValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[]{null, null}, (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new java.util.Date[]{null, null}, (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new java.util.Date[]{null, null}, (Object[])event.getTimestampValues().toArray());
            Assert.assertArrayEquals((Object[])new BigDecimal[]{null, null}, (Object[])event.getDecimalValues().toArray());
            Assert.assertArrayEquals((Object[])new LocalDate[]{null, null}, (Object[])event.getLocalDateValues().toArray());
            Assert.assertArrayEquals((Object[])new LocalDateTime[]{null, null}, (Object[])event.getLocalDateTimeValues().toArray());
        });
    }

    @Test
    public void testEmptyArrays() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(100L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(101L);
            event.setSensorIds(Collections.emptyList());
            event.setSensorNames(Collections.emptyList());
            event.setSensorValues(Collections.emptyList());
            event.setSensorLongValues(Collections.emptyList());
            event.setSensorBooleanValues(Collections.emptyList());
            event.setSensorDoubleValues(Collections.emptyList());
            event.setSensorStates(Collections.emptyList());
            event.setDateValues(Collections.emptyList());
            event.setTimestampValues(Collections.emptyList());
            event.setDecimalValues(Collections.emptyList());
            event.setLocalDateValues(Collections.emptyList());
            event.setLocalDateTimeValues(Collections.emptyList());
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)101L);
            Assert.assertArrayEquals((Object[])new UUID[0], (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[0], (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[0], (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[0], (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new Boolean[0], (Object[])event.getSensorBooleanValues().toArray());
            Assert.assertArrayEquals((Object[])new Double[0], (Object[])event.getSensorDoubleValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[0], (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new java.util.Date[0], (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new java.util.Date[0], (Object[])event.getTimestampValues().toArray());
            Assert.assertArrayEquals((Object[])new BigDecimal[0], (Object[])event.getDecimalValues().toArray());
            Assert.assertArrayEquals((Object[])new LocalDate[0], (Object[])event.getLocalDateValues().toArray());
            Assert.assertArrayEquals((Object[])new LocalDateTime[0], (Object[])event.getLocalDateTimeValues().toArray());
        });
    }

    @Test
    public void testNullArrays() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(100L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(101L);
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)101L);
            Assert.assertEquals(null, event.getSensorIds());
            Assert.assertEquals(null, event.getSensorNames());
            Assert.assertEquals(null, event.getSensorLongValues());
            Assert.assertEquals(null, event.getSensorStates());
            Assert.assertEquals(null, event.getDateValues());
            Assert.assertEquals(null, event.getTimestampValues());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        private Long id;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_ids", columnDefinition="uuid[]")
        private List<UUID> sensorIds;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_names", columnDefinition="text[]")
        private List<String> sensorNames;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private List<Integer> sensorValues;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_long_values", columnDefinition="bigint[]")
        private List<Long> sensorLongValues;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_boolean_values", columnDefinition="boolean[]")
        private List<Boolean> sensorBooleanValues;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_double_values", columnDefinition="float8[]")
        private List<Double> sensorDoubleValues;
        @Type(value=ListArrayType.class, parameters={@Parameter(name="sql_array_type", value="sensor_state")})
        @Column(name="sensor_states", columnDefinition="sensor_state[]")
        private List<SensorState> sensorStates;
        @Type(value=ListArrayType.class)
        @Column(name="date_values", columnDefinition="date[]")
        private List<java.util.Date> dateValues;
        @Type(value=ListArrayType.class)
        @Column(name="timestamp_values", columnDefinition="timestamp[]")
        private List<java.util.Date> timestampValues;
        @Type(value=ListArrayType.class)
        @Column(name="decimal_values", columnDefinition="decimal[]")
        private List<BigDecimal> decimalValues;
        @Type(value=ListArrayType.class)
        @Column(name="localdate_values", columnDefinition="date[]")
        private List<LocalDate> localDateValues;
        @Type(value=ListArrayType.class)
        @Column(name="localdatetime_values", columnDefinition="timestamp[]")
        private List<LocalDateTime> localDateTimeValues;
        @Type(value=ListArrayType.class)
        @Column(name="localdatetime_set_values", columnDefinition="timestamp[]")
        private Set<LocalDateTime> localDateTimeSetValues;

        public Long getId() {
            return this.id;
        }

        public Event setId(Long id) {
            this.id = id;
            return this;
        }

        public List<UUID> getSensorIds() {
            return this.sensorIds;
        }

        public Event setSensorIds(List<UUID> sensorIds) {
            this.sensorIds = sensorIds;
            return this;
        }

        public List<String> getSensorNames() {
            return this.sensorNames;
        }

        public Event setSensorNames(List<String> sensorNames) {
            this.sensorNames = sensorNames;
            return this;
        }

        public List<Integer> getSensorValues() {
            return this.sensorValues;
        }

        public Event setSensorValues(List<Integer> sensorValues) {
            this.sensorValues = sensorValues;
            return this;
        }

        public List<Long> getSensorLongValues() {
            return this.sensorLongValues;
        }

        public Event setSensorLongValues(List<Long> sensorLongValues) {
            this.sensorLongValues = sensorLongValues;
            return this;
        }

        public List<Boolean> getSensorBooleanValues() {
            return this.sensorBooleanValues;
        }

        public Event setSensorBooleanValues(List<Boolean> sensorBooleanValues) {
            this.sensorBooleanValues = sensorBooleanValues;
            return this;
        }

        public List<Double> getSensorDoubleValues() {
            return this.sensorDoubleValues;
        }

        public Event setSensorDoubleValues(List<Double> sensorDoubleValues) {
            this.sensorDoubleValues = sensorDoubleValues;
            return this;
        }

        public List<SensorState> getSensorStates() {
            return this.sensorStates;
        }

        public Event setSensorStates(List<SensorState> sensorStates) {
            this.sensorStates = sensorStates;
            return this;
        }

        public List<java.util.Date> getDateValues() {
            return this.dateValues;
        }

        public Event setDateValues(List<java.util.Date> dateValues) {
            this.dateValues = dateValues;
            return this;
        }

        public List<java.util.Date> getTimestampValues() {
            return this.timestampValues;
        }

        public Event setTimestampValues(List<java.util.Date> timestampValues) {
            this.timestampValues = timestampValues;
            return this;
        }

        public List<BigDecimal> getDecimalValues() {
            return this.decimalValues;
        }

        public Event setDecimalValues(List<BigDecimal> decimalValues) {
            this.decimalValues = decimalValues;
            return this;
        }

        public List<LocalDate> getLocalDateValues() {
            return this.localDateValues;
        }

        public Event setLocalDateValues(List<LocalDate> localDateValues) {
            this.localDateValues = localDateValues;
            return this;
        }

        public List<LocalDateTime> getLocalDateTimeValues() {
            return this.localDateTimeValues;
        }

        public Event setLocalDateTimeValues(List<LocalDateTime> localDateTimeValues) {
            this.localDateTimeValues = localDateTimeValues;
            return this;
        }

        public Set<LocalDateTime> getLocalDateTimeSetValues() {
            return this.localDateTimeSetValues;
        }

        public Event setLocalDateTimeSetValues(Set<LocalDateTime> localDateTimeSetValues) {
            this.localDateTimeSetValues = localDateTimeSetValues;
            return this;
        }
    }

    public static enum SensorState {
        ONLINE,
        OFFLINE,
        UNKNOWN;

    }
}

