/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.DateArrayType;
import io.hypersistence.utils.hibernate.type.array.DoubleArrayType;
import io.hypersistence.utils.hibernate.type.array.FloatArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.LongArrayType;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.type.array.TimestampArrayType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class HSQLDBArrayTypeTest
extends AbstractTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Test
    public void test() {
        Date date1 = Date.from(LocalDate.of(1991, 12, 31).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date date2 = Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorNames(new String[]{"Temperature", "Pressure"});
            event.setSensorValues(new int[]{12, 756});
            event.setSensorLongValues(new long[]{42L, 0x7FFFFFFFFFFFFFF8L});
            event.setSensorDoubleValues(new double[]{0.123, 456.789});
            event.setSensorFloatValues(new float[]{1.23f, 45.789f});
            event.setDateValues(new Date[]{date1, date2});
            event.setTimestampValues(new Date[]{date1, date2});
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", "Pressure"}, (Object[])event.getSensorNames());
            Assert.assertArrayEquals((int[])new int[]{12, 756}, (int[])event.getSensorValues());
            Assert.assertArrayEquals((long[])new long[]{42L, 0x7FFFFFFFFFFFFFF8L}, (long[])event.getSensorLongValues());
            Assert.assertArrayEquals((double[])new double[]{0.123, 456.789}, (double[])event.getSensorDoubleValues(), (double)0.01);
            Assert.assertArrayEquals((float[])new float[]{1.23f, 45.789f}, (float[])event.getSensorFloatValues(), (float)0.01f);
            Assert.assertArrayEquals((Object[])new Date[]{date1, date2}, (Object[])event.getDateValues());
            Assert.assertArrayEquals((Object[])new Date[]{date1, date2}, (Object[])event.getTimestampValues());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=StringArrayType.class, parameters={@Parameter(name="sql_array_type", value="varchar")})
        @Column(name="sensor_names", columnDefinition="VARCHAR(20) ARRAY[10]")
        private String[] sensorNames;
        @Type(value=IntArrayType.class)
        @Column(name="sensor_values", columnDefinition="INT ARRAY DEFAULT ARRAY[]")
        private int[] sensorValues;
        @Type(value=LongArrayType.class)
        @Column(name="sensor_long_values", columnDefinition="BIGINT ARRAY DEFAULT ARRAY[]")
        private long[] sensorLongValues;
        @Type(value=DoubleArrayType.class, parameters={@Parameter(name="sql_array_type", value="double")})
        @Column(name="sensor_double_values", columnDefinition="DOUBLE ARRAY DEFAULT ARRAY[]")
        private double[] sensorDoubleValues;
        @Type(value=FloatArrayType.class, parameters={@Parameter(name="sql_array_type", value="float")})
        @Column(name="sensor_float_values", columnDefinition="FLOAT ARRAY DEFAULT ARRAY[]")
        private float[] sensorFloatValues;
        @Type(value=DateArrayType.class)
        @Column(name="date_values", columnDefinition="DATE ARRAY DEFAULT ARRAY[]")
        private Date[] dateValues;
        @Type(value=TimestampArrayType.class)
        @Column(name="timestamp_values", columnDefinition="TIMESTAMP ARRAY DEFAULT ARRAY[]")
        private Date[] timestampValues;

        public String[] getSensorNames() {
            return this.sensorNames;
        }

        public void setSensorNames(String[] sensorNames) {
            this.sensorNames = sensorNames;
        }

        public int[] getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(int[] sensorValues) {
            this.sensorValues = sensorValues;
        }

        public long[] getSensorLongValues() {
            return this.sensorLongValues;
        }

        public void setSensorLongValues(long[] sensorLongValues) {
            this.sensorLongValues = sensorLongValues;
        }

        public double[] getSensorDoubleValues() {
            return this.sensorDoubleValues;
        }

        public void setSensorDoubleValues(double[] sensorDoubleValues) {
            this.sensorDoubleValues = sensorDoubleValues;
        }

        public float[] getSensorFloatValues() {
            return this.sensorFloatValues;
        }

        public void setSensorFloatValues(float[] sensorFloatValues) {
            this.sensorFloatValues = sensorFloatValues;
        }

        public Date[] getDateValues() {
            return this.dateValues;
        }

        public void setDateValues(Date[] dateValues) {
            this.dateValues = dateValues;
        }

        public Date[] getTimestampValues() {
            return this.timestampValues;
        }

        public void setTimestampValues(Date[] timestampValues) {
            this.timestampValues = timestampValues;
        }
    }
}

