/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.ListArrayType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.sql.DataSource;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.junit.Assert;
import org.junit.Test;

public class EhcacheListArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.setProperty("hibernate.cache.use_second_level_cache", "true");
        properties.setProperty("hibernate.cache.use_query_cache", "true");
        properties.setProperty("hibernate.cache.region.factory_class", "jcache");
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("DROP TYPE sensor_state CASCADE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TYPE sensor_state AS ENUM ('ONLINE', 'OFFLINE', 'UNKNOWN')");
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\"");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void test() {
        Date date1 = Date.from(LocalDate.of(1991, 12, 31).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date date2 = Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorIds(Arrays.asList(UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")));
            event.setSensorNames(Arrays.asList("Temperature", "Pressure"));
            event.setSensorValues(Arrays.asList(12, 756));
            event.setSensorLongValues(Arrays.asList(42L, 0x7FFFFFFFFFFFFFF8L));
            event.setSensorStates(Arrays.asList(SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN));
            event.setDateValues(Arrays.asList(date1, date2));
            event.setTimestampValues(Arrays.asList(date1, date2));
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[]{UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")}, (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", "Pressure"}, (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[]{12, 756}, (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[]{42L, 0x7FFFFFFFFFFFFFF8L}, (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[]{SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN}, (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new Date[]{date1, date2}, (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new Date[]{date1, date2}, (Object[])event.getTimestampValues().toArray());
        });
        this.doInJPA(entityManager -> {
            List events = ((NativeQuery)entityManager.createNativeQuery("select    id,    sensor_ids,    sensor_names,    sensor_values from event where id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("sensor_ids", UUID[].class).addScalar("sensor_names", String[].class).addScalar("sensor_values", int[].class).getResultList();
            Assert.assertEquals((long)2L, (long)events.size());
        });
    }

    @Test
    public void testMixingNullValues() {
        Date date = Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorIds(Arrays.asList(null, UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")));
            event.setSensorNames(Arrays.asList("Temperature", null));
            event.setSensorValues(Arrays.asList(null, 756));
            event.setSensorLongValues(Arrays.asList(null, 0x7FFFFFFFFFFFFFF8L));
            event.setSensorStates(Arrays.asList(null, SensorState.OFFLINE, SensorState.ONLINE, null));
            event.setDateValues(Arrays.asList(null, date));
            event.setTimestampValues(Arrays.asList(null, date));
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[]{null, UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")}, (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", null}, (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[]{null, 756}, (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[]{null, 0x7FFFFFFFFFFFFFF8L}, (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[]{null, SensorState.OFFLINE, SensorState.ONLINE, null}, (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new Date[]{null, date}, (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new Date[]{null, date}, (Object[])event.getTimestampValues().toArray());
        });
    }

    @Test
    public void testNullValues() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorIds(Arrays.asList(null, null));
            event.setSensorNames(Arrays.asList(null, null));
            event.setSensorValues(Arrays.asList(null, null));
            event.setSensorLongValues(Arrays.asList(null, null));
            event.setSensorStates(Arrays.asList(null, null));
            event.setDateValues(Arrays.asList(null, null));
            event.setTimestampValues(Arrays.asList(null, null));
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[]{null, null}, (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[]{null, null}, (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[]{null, null}, (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[]{null, null}, (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[]{null, null}, (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new Date[]{null, null}, (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new Date[]{null, null}, (Object[])event.getTimestampValues().toArray());
        });
    }

    @Test
    public void testEmptyArrays() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorIds(Collections.emptyList());
            event.setSensorNames(Collections.emptyList());
            event.setSensorValues(Collections.emptyList());
            event.setSensorLongValues(Collections.emptyList());
            event.setSensorStates(Collections.emptyList());
            event.setDateValues(Collections.emptyList());
            event.setTimestampValues(Collections.emptyList());
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[0], (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[0], (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[0], (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[0], (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[0], (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new Date[0], (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new Date[0], (Object[])event.getTimestampValues().toArray());
        });
    }

    @Test
    public void testNullArrays() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertEquals(null, event.getSensorIds());
            Assert.assertEquals(null, event.getSensorNames());
            Assert.assertEquals(null, event.getSensorLongValues());
            Assert.assertEquals(null, event.getSensorStates());
            Assert.assertEquals(null, event.getDateValues());
            Assert.assertEquals(null, event.getTimestampValues());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    @Cacheable
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public static class Event
    extends BaseEntity {
        @Type(value=ListArrayType.class)
        @Column(name="sensor_ids", columnDefinition="uuid[]")
        private List<UUID> sensorIds;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_names", columnDefinition="text[]")
        private List<String> sensorNames;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private List<Integer> sensorValues;
        @Type(value=ListArrayType.class)
        @Column(name="sensor_long_values", columnDefinition="bigint[]")
        private List<Long> sensorLongValues;
        @Type(value=ListArrayType.class, parameters={@Parameter(name="sql_array_type", value="sensor_state")})
        @Column(name="sensor_states", columnDefinition="sensor_state[]")
        private List<SensorState> sensorStates;
        @Type(value=ListArrayType.class)
        @Column(name="date_values", columnDefinition="date[]")
        private List<Date> dateValues;
        @Type(value=ListArrayType.class)
        @Column(name="timestamp_values", columnDefinition="timestamp[]")
        private List<Date> timestampValues;

        public List<UUID> getSensorIds() {
            return this.sensorIds;
        }

        public void setSensorIds(List<UUID> sensorIds) {
            this.sensorIds = sensorIds;
        }

        public List<String> getSensorNames() {
            return this.sensorNames;
        }

        public void setSensorNames(List<String> sensorNames) {
            this.sensorNames = sensorNames;
        }

        public List<Integer> getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(List<Integer> sensorValues) {
            this.sensorValues = sensorValues;
        }

        public List<Long> getSensorLongValues() {
            return this.sensorLongValues;
        }

        public void setSensorLongValues(List<Long> sensorLongValues) {
            this.sensorLongValues = sensorLongValues;
        }

        public List<SensorState> getSensorStates() {
            return this.sensorStates;
        }

        public void setSensorStates(List<SensorState> sensorStates) {
            this.sensorStates = sensorStates;
        }

        public List<Date> getDateValues() {
            return this.dateValues;
        }

        public void setDateValues(List<Date> dateValues) {
            this.dateValues = dateValues;
        }

        public List<Date> getTimestampValues() {
            return this.timestampValues;
        }

        public void setTimestampValues(List<Date> timestampValues) {
            this.timestampValues = timestampValues;
        }
    }

    public static enum SensorState {
        ONLINE,
        OFFLINE,
        UNKNOWN;

    }
}

