/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.ListArrayType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class DefaultEmptyListArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("DROP TYPE sensor_state CASCADE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TYPE sensor_state AS ENUM ('ONLINE', 'OFFLINE', 'UNKNOWN')");
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\"");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void testEmptyArrays() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[0], (Object[])event.getSensorIds().toArray());
            Assert.assertArrayEquals((Object[])new String[0], (Object[])event.getSensorNames().toArray());
            Assert.assertArrayEquals((Object[])new Integer[0], (Object[])event.getSensorValues().toArray());
            Assert.assertArrayEquals((Object[])new Long[0], (Object[])event.getSensorLongValues().toArray());
            Assert.assertArrayEquals((Object[])new SensorState[0], (Object[])event.getSensorStates().toArray());
            Assert.assertArrayEquals((Object[])new Date[0], (Object[])event.getDateValues().toArray());
            Assert.assertArrayEquals((Object[])new Date[0], (Object[])event.getTimestampValues().toArray());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=ListArrayType.class)
        @Column(name="sensor_ids", columnDefinition="uuid[]")
        private List<UUID> sensorIds = new ArrayList<UUID>();
        @Type(value=ListArrayType.class)
        @Column(name="sensor_names", columnDefinition="text[]")
        private List<String> sensorNames = new ArrayList<String>();
        @Type(value=ListArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private List<Integer> sensorValues = new ArrayList<Integer>();
        @Type(value=ListArrayType.class)
        @Column(name="sensor_long_values", columnDefinition="bigint[]")
        private List<Long> sensorLongValues = new ArrayList<Long>();
        @Type(value=ListArrayType.class, parameters={@Parameter(name="sql_array_type", value="sensor_state")})
        @Column(name="sensor_states", columnDefinition="sensor_state[]")
        private List<SensorState> sensorStates = new ArrayList<SensorState>();
        @Type(value=ListArrayType.class)
        @Column(name="date_values", columnDefinition="date[]")
        private List<Date> dateValues = new ArrayList<Date>();
        @Type(value=ListArrayType.class)
        @Column(name="timestamp_values", columnDefinition="timestamp[]")
        private List<Date> timestampValues = new ArrayList<Date>();

        public List<UUID> getSensorIds() {
            return this.sensorIds;
        }

        public void setSensorIds(List<UUID> sensorIds) {
            this.sensorIds = sensorIds;
        }

        public List<String> getSensorNames() {
            return this.sensorNames;
        }

        public void setSensorNames(List<String> sensorNames) {
            this.sensorNames = sensorNames;
        }

        public List<Integer> getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(List<Integer> sensorValues) {
            this.sensorValues = sensorValues;
        }

        public List<Long> getSensorLongValues() {
            return this.sensorLongValues;
        }

        public void setSensorLongValues(List<Long> sensorLongValues) {
            this.sensorLongValues = sensorLongValues;
        }

        public List<SensorState> getSensorStates() {
            return this.sensorStates;
        }

        public void setSensorStates(List<SensorState> sensorStates) {
            this.sensorStates = sensorStates;
        }

        public List<Date> getDateValues() {
            return this.dateValues;
        }

        public void setDateValues(List<Date> dateValues) {
            this.dateValues = dateValues;
        }

        public List<Date> getTimestampValues() {
            return this.timestampValues;
        }

        public void setTimestampValues(List<Date> timestampValues) {
            this.timestampValues = timestampValues;
        }
    }

    public static enum SensorState {
        ONLINE,
        OFFLINE,
        UNKNOWN;

    }
}

