/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.hibernate.util.ExceptionUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.annotations.Type;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.query.TypedParameterValue;
import org.junit.Assert;
import org.junit.Test;

public class BindArrayTypeQueryParameterTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE OR REPLACE FUNCTION     fn_array_contains(       left_array integer[],        right_array integer[]) RETURNS        boolean AS $$ BEGIN   return left_array @> right_array; END; $$ LANGUAGE 'plpgsql';");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Event event = new Event();
            event.setId(1L);
            event.setName("Temperature");
            event.setValues(new int[]{1, 2, 3});
            entityManager.persist((Object)event);
        });
    }

    @Test
    public void testJPQLWithDefaultParameterBiding() {
        try {
            this.doInJPA(entityManager -> {
                Event event = (Event)entityManager.createQuery("select e from Event e where    fn_array_contains(e.values, :arrayValues) = true", Event.class).setParameter("arrayValues", (Object)new int[]{2, 3}).getSingleResult();
            });
        }
        catch (Exception e) {
            Exception rootCause = (Exception)ExceptionUtil.rootCause(e);
            Assert.assertTrue((boolean)rootCause.getMessage().contains("ERROR: function fn_array_contains(integer[], bytea) does not exist"));
        }
    }

    @Test
    public void testJPQLWithExplicitParameterTypeBinding() {
        this.doInJPA(entityManager -> {
            Event event = (Event)((Query)entityManager.createQuery("select e from Event e where    fn_array_contains(e.values, :arrayValues) = true", Event.class).unwrap(Query.class)).setParameter("arrayValues", (Object)new int[]{2, 3}, (BindableType)IntArrayType.INSTANCE).getSingleResult();
            Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])event.getValues());
        });
    }

    @Test
    public void testJPQLWithTypedParameterValue() {
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.createQuery("select e from Event e where    fn_array_contains(e.values, :arrayValues) = true", Event.class).setParameter("arrayValues", (Object)new TypedParameterValue((BindableType)IntArrayType.INSTANCE, (Object)new int[]{2, 3})).getSingleResult();
            Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])event.getValues());
        });
    }

    @Test
    public void testCriteriaAPI() {
        this.doInJPA(entityManager -> {
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(Event.class);
            Root root = cq.from(Event.class);
            cq.select((Selection)root);
            ParameterExpression containValues = cb.parameter(int[].class, "arrayValues");
            cq.where((Expression)cb.equal(cb.function("fn_array_contains", Boolean.class, new Expression[]{root.get("values"), containValues}), (Object)Boolean.TRUE));
            Event event = (Event)((Query)entityManager.createQuery(cq).unwrap(Query.class)).setParameter("arrayValues", (Object)new int[]{2, 3}, (BindableType)IntArrayType.INSTANCE).getSingleResult();
            Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])event.getValues());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        private Long id;
        private String name;
        @Type(value=IntArrayType.class)
        @Column(name="event_values", columnDefinition="integer[]")
        private int[] values;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int[] getValues() {
            return this.values;
        }

        public void setValues(int[] values) {
            this.values = values;
        }
    }
}

