/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.BooleanArrayType;
import io.hypersistence.utils.hibernate.type.array.DateArrayType;
import io.hypersistence.utils.hibernate.type.array.DecimalArrayType;
import io.hypersistence.utils.hibernate.type.array.DoubleArrayType;
import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.FloatArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateTimeArrayType;
import io.hypersistence.utils.hibernate.type.array.LongArrayType;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.type.array.TimestampArrayType;
import io.hypersistence.utils.hibernate.type.array.UUIDArrayType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.junit.Assert;
import org.junit.Test;

public class ArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        DataSource dataSource = this.newDataSource();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.executeUpdate("DROP TYPE sensor_state CASCADE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TYPE sensor_state AS ENUM ('ONLINE', 'OFFLINE', 'UNKNOWN')");
            statement.executeUpdate("CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\"");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        super.init();
    }

    @Test
    public void test() {
        Date date1 = Date.from(LocalDate.of(1991, 12, 31).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date date2 = Date.from(LocalDate.of(1990, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Event event = new Event();
            event.setId(1L);
            event.setSensorIds(new UUID[]{UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")});
            event.setSensorNames(new String[]{"Temperature", "Pressure"});
            event.setSensorValues(new int[]{12, 756});
            event.setSensorLongValues(new long[]{42L, 0x7FFFFFFFFFFFFFF8L});
            event.setSensorDoubleValues(new double[]{0.123, 456.789});
            event.setSensorFloatValues(new float[]{1.2f, 4.35f});
            event.setSensorStates(new SensorState[]{SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN});
            event.setDateValues(new Date[]{date1, date2});
            event.setTimestampValues(new Date[]{date1, date2});
            event.setDecimalValues(new BigDecimal[]{BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.TEN});
            event.setLocalDateValues(new LocalDate[]{LocalDate.of(2022, 3, 22), LocalDate.of(2021, 4, 21)});
            event.setLocalDateTimeValues(new LocalDateTime[]{LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2021, 4, 21, 22, 33, 44)});
            event.setSensorBooleanValues(new Boolean[]{false, true, true});
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertArrayEquals((Object[])new UUID[]{UUID.fromString("c65a3bcb-8b36-46d4-bddb-ae96ad016eb1"), UUID.fromString("72e95717-5294-4c15-aa64-a3631cf9a800")}, (Object[])event.getSensorIds());
            Assert.assertArrayEquals((Object[])new String[]{"Temperature", "Pressure"}, (Object[])event.getSensorNames());
            Assert.assertArrayEquals((int[])new int[]{12, 756}, (int[])event.getSensorValues());
            Assert.assertArrayEquals((long[])new long[]{42L, 0x7FFFFFFFFFFFFFF8L}, (long[])event.getSensorLongValues());
            Assert.assertArrayEquals((double[])new double[]{0.123, 456.789}, (double[])event.getSensorDoubleValues(), (double)0.01);
            Assert.assertArrayEquals((float[])new float[]{1.2f, 4.35f}, (float[])event.getSensorFloatValues(), (float)0.01f);
            Assert.assertArrayEquals((Object[])new SensorState[]{SensorState.ONLINE, SensorState.OFFLINE, SensorState.ONLINE, SensorState.UNKNOWN}, (Object[])event.getSensorStates());
            Assert.assertArrayEquals((Object[])new Date[]{date1, date2}, (Object[])event.getDateValues());
            Assert.assertArrayEquals((Object[])new Date[]{date1, date2}, (Object[])event.getTimestampValues());
            Assert.assertArrayEquals((Object[])new BigDecimal[]{BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.TEN}, (Object[])event.getDecimalValues());
            Assert.assertArrayEquals((Object[])new LocalDate[]{LocalDate.of(2022, 3, 22), LocalDate.of(2021, 4, 21)}, (Object[])event.getLocalDateValues());
            Assert.assertArrayEquals((Object[])new LocalDateTime[]{LocalDateTime.of(2022, 3, 22, 11, 22, 33), LocalDateTime.of(2021, 4, 21, 22, 33, 44)}, (Object[])event.getLocalDateTimeValues());
            Assert.assertArrayEquals((Object[])new Boolean[]{false, true, true}, (Object[])event.getSensorBooleanValues());
        });
        this.doInJPA(entityManager -> {
            List events = ((NativeQuery)entityManager.createNativeQuery("select    id,    sensor_ids,    sensor_names,    sensor_values,    date_values   from event where id >= :id", Tuple.class).setParameter("id", (Object)0).unwrap(NativeQuery.class)).addScalar("sensor_ids", UUID[].class).addScalar("sensor_names", String[].class).addScalar("sensor_values", int[].class).addScalar("date_values", Date[].class).getResultList();
            Assert.assertEquals((long)2L, (long)events.size());
        });
    }

    @Test
    public void testLargeArray() {
        int[] sensorValues = new int[100];
        Arrays.fill(sensorValues, 0, 10, 123);
        Arrays.fill(sensorValues, 10, 50, 456);
        Arrays.fill(sensorValues, 50, 90, 789);
        Arrays.fill(sensorValues, 90, 100, 0);
        this.doInJPA(entityManager -> {
            Event event = new Event();
            event.setId(0L);
            event.setSensorValues(sensorValues);
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)0L);
            Assert.assertArrayEquals((int[])sensorValues, (int[])event.getSensorValues());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=UUIDArrayType.class)
        @Column(name="sensor_ids", columnDefinition="uuid[]")
        private UUID[] sensorIds;
        @Type(value=StringArrayType.class)
        @Column(name="sensor_names", columnDefinition="text[]")
        private String[] sensorNames;
        @Type(value=IntArrayType.class)
        @Column(name="sensor_values", columnDefinition="integer[]")
        private int[] sensorValues;
        @Type(value=LongArrayType.class)
        @Column(name="sensor_long_values", columnDefinition="bigint[]")
        private long[] sensorLongValues;
        @Type(value=BooleanArrayType.class)
        @Column(name="sensor_boolean_values", columnDefinition="boolean[]")
        private Boolean[] sensorBooleanValues;
        @Type(value=DoubleArrayType.class)
        @Column(name="sensor_double_values", columnDefinition="float8[]")
        private double[] sensorDoubleValues;
        @Type(value=FloatArrayType.class)
        @Column(name="sensor_float_values", columnDefinition="float4[]")
        private float[] sensorFloatValues;
        @Type(value=DateArrayType.class)
        @Column(name="date_values", columnDefinition="date[]")
        private Date[] dateValues;
        @Type(value=TimestampArrayType.class)
        @Column(name="timestamp_values", columnDefinition="timestamp[]")
        private Date[] timestampValues;
        @Type(value=DecimalArrayType.class)
        @Column(name="decimal_values", columnDefinition="decimal[]")
        private BigDecimal[] decimalValues;
        @Type(value=LocalDateArrayType.class)
        @Column(name="localdate_values", columnDefinition="date[]")
        private LocalDate[] localDateValues;
        @Type(value=LocalDateTimeArrayType.class)
        @Column(name="localdatetime_values", columnDefinition="timestamp[]")
        private LocalDateTime[] localDateTimeValues;
        @Type(value=EnumArrayType.class, parameters={@Parameter(name="sql_array_type", value="sensor_state")})
        @Column(name="sensor_states", columnDefinition="sensor_state[]")
        private SensorState[] sensorStates;

        public UUID[] getSensorIds() {
            return this.sensorIds;
        }

        public void setSensorIds(UUID[] sensorIds) {
            this.sensorIds = sensorIds;
        }

        public String[] getSensorNames() {
            return this.sensorNames;
        }

        public void setSensorNames(String[] sensorNames) {
            this.sensorNames = sensorNames;
        }

        public int[] getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(int[] sensorValues) {
            this.sensorValues = sensorValues;
        }

        public long[] getSensorLongValues() {
            return this.sensorLongValues;
        }

        public void setSensorLongValues(long[] sensorLongValues) {
            this.sensorLongValues = sensorLongValues;
        }

        public Boolean[] getSensorBooleanValues() {
            return this.sensorBooleanValues;
        }

        public void setSensorBooleanValues(Boolean[] sensorBooleanValues) {
            this.sensorBooleanValues = sensorBooleanValues;
        }

        public double[] getSensorDoubleValues() {
            return this.sensorDoubleValues;
        }

        public void setSensorDoubleValues(double[] sensorDoubleValues) {
            this.sensorDoubleValues = sensorDoubleValues;
        }

        public float[] getSensorFloatValues() {
            return this.sensorFloatValues;
        }

        public void setSensorFloatValues(float[] sensorFloatValues) {
            this.sensorFloatValues = sensorFloatValues;
        }

        public SensorState[] getSensorStates() {
            return this.sensorStates;
        }

        public void setSensorStates(SensorState[] sensorStates) {
            this.sensorStates = sensorStates;
        }

        public Date[] getDateValues() {
            return this.dateValues;
        }

        public void setDateValues(Date[] dateValues) {
            this.dateValues = dateValues;
        }

        public Date[] getTimestampValues() {
            return this.timestampValues;
        }

        public void setTimestampValues(Date[] timestampValues) {
            this.timestampValues = timestampValues;
        }

        public BigDecimal[] getDecimalValues() {
            return this.decimalValues;
        }

        public void setDecimalValues(BigDecimal[] decimalValues) {
            this.decimalValues = decimalValues;
        }

        public LocalDate[] getLocalDateValues() {
            return this.localDateValues;
        }

        public void setLocalDateValues(LocalDate[] localDateValues) {
            this.localDateValues = localDateValues;
        }

        public LocalDateTime[] getLocalDateTimeValues() {
            return this.localDateTimeValues;
        }

        public void setLocalDateTimeValues(LocalDateTime[] localDateTimeValues) {
            this.localDateTimeValues = localDateTimeValues;
        }
    }

    public static enum SensorState {
        ONLINE,
        OFFLINE,
        UNKNOWN;

    }
}

