/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import io.hypersistence.utils.hibernate.query.SQLExtractor;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Test;

public class SQLExtractorTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class, PostComment.class};
    }

    @Test
    public void testJPQL() {
        this.doInJPA(entityManager -> {
            TypedQuery jpql = entityManager.createQuery("select    YEAR(p.createdOn) as year,    count(p) as postCount from    Post p group by    YEAR(p.createdOn)", Tuple.class);
            String sql = SQLExtractor.from((Query)jpql);
            Assert.assertNotNull((Object)sql);
            this.LOGGER.info("The JPQL query: [\n{}\n]\ngenerates the following SQL query: [\n{}\n]", (Object)((org.hibernate.query.Query)jpql.unwrap(org.hibernate.query.Query.class)).getQueryString(), (Object)sql);
        });
    }

    @Test
    public void testCriteriaAPI() {
        this.doInJPA(entityManager -> {
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(PostComment.class);
            Root postComment = criteria.from(PostComment.class);
            Join post = postComment.join("post");
            criteria.where((Expression)builder.like((Expression)post.get("title"), "%Java%"));
            criteria.orderBy(new Order[]{builder.asc((Expression)postComment.get("id"))});
            TypedQuery criteriaQuery = entityManager.createQuery(criteria);
            String sql = SQLExtractor.from((Query)criteriaQuery);
            Assert.assertNotNull((Object)sql);
            this.LOGGER.info("The Criteria API query: [\n{}\n]\ngenerates the following SQL query: [\n{}\n]", (Object)((org.hibernate.query.Query)criteriaQuery.unwrap(org.hibernate.query.Query.class)).getQueryString(), (Object)sql);
        });
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @Id
        private Long id;
        private String title;
        @Column(name="created_on")
        private LocalDate createdOn;

        public Long getId() {
            return this.id;
        }

        public Post setId(Long id) {
            this.id = id;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Post setTitle(String title) {
            this.title = title;
            return this;
        }

        public LocalDate getCreatedOn() {
            return this.createdOn;
        }

        public Post setCreatedOn(LocalDate createdOn) {
            this.createdOn = createdOn;
            return this;
        }
    }

    @Entity(name="PostComment")
    @Table(name="post_comment")
    public static class PostComment {
        @Id
        private Long id;
        @ManyToOne(fetch=FetchType.LAZY)
        private Post post;
        private String review;

        public Long getId() {
            return this.id;
        }

        public PostComment setId(Long id) {
            this.id = id;
            return this;
        }

        public Post getPost() {
            return this.post;
        }

        public PostComment setPost(Post post) {
            this.post = post;
            return this;
        }

        public String getReview() {
            return this.review;
        }

        public PostComment setReview(String review) {
            this.review = review;
            return this;
        }
    }
}

