/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import io.hypersistence.utils.hibernate.query.ListResultTransformer;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.junit.Assert;
import org.junit.Test;

public class ListResultTransformerTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class};
    }

    @Override
    public void afterInit() {
        this.doInJPA(entityManager -> {
            entityManager.persist((Object)new Post().setId(1L).setTitle("High-Performance Java Persistence eBook has been released!").setCreatedOn(LocalDate.of(2016, 8, 30)));
            entityManager.persist((Object)new Post().setId(2L).setTitle("High-Performance Java Persistence paperback has been released!").setCreatedOn(LocalDate.of(2016, 10, 12)));
            entityManager.persist((Object)new Post().setId(3L).setTitle("High-Performance Java Persistence Mach 1 video course has been released!").setCreatedOn(LocalDate.of(2018, 1, 30)));
            entityManager.persist((Object)new Post().setId(4L).setTitle("High-Performance Java Persistence Mach 2 video course has been released!").setCreatedOn(LocalDate.of(2018, 5, 8)));
            entityManager.persist((Object)new Post().setId(5L).setTitle("Hypersistence Optimizer has been released!").setCreatedOn(LocalDate.of(2019, 3, 19)));
        });
    }

    @Test
    public void testTransformer() {
        this.doInJPA(entityManager -> {
            List postCountByYearMap = ((Query)entityManager.createQuery("select    YEAR(p.createdOn) as year,    count(p) as postCount from Post p group by    YEAR(p.createdOn) order by    YEAR(p.createdOn)").unwrap(Query.class)).setResultTransformer(new ResultTransformer(){

                public Object transformTuple(Object[] tuple, String[] aliases) {
                    return new PostCountByYear(((Number)tuple[0]).intValue(), ((Number)tuple[1]).intValue());
                }

                public List transformList(List tuples) {
                    return tuples;
                }
            }).getResultList();
            Assert.assertEquals((long)2016L, (long)((PostCountByYear)postCountByYearMap.get(0)).getYear());
            Assert.assertEquals((long)2L, (long)((PostCountByYear)postCountByYearMap.get(0)).getPostCount());
            Assert.assertEquals((long)2018L, (long)((PostCountByYear)postCountByYearMap.get(1)).getYear());
            Assert.assertEquals((long)2L, (long)((PostCountByYear)postCountByYearMap.get(1)).getPostCount());
            Assert.assertEquals((long)2019L, (long)((PostCountByYear)postCountByYearMap.get(2)).getYear());
            Assert.assertEquals((long)1L, (long)((PostCountByYear)postCountByYearMap.get(2)).getPostCount());
        });
    }

    @Test
    public void testListResultTransformer() {
        this.doInJPA(entityManager -> {
            List postCountByYearMap = ((Query)entityManager.createQuery("select    YEAR(p.createdOn) as year,    count(p) as postCount from Post p group by    YEAR(p.createdOn) order by    YEAR(p.createdOn)").unwrap(Query.class)).setResultTransformer((ResultTransformer)(ListResultTransformer & Serializable)(tuple, aliases) -> new PostCountByYear(((Number)tuple[0]).intValue(), ((Number)tuple[1]).intValue())).getResultList();
            Assert.assertEquals((long)2016L, (long)((PostCountByYear)postCountByYearMap.get(0)).getYear());
            Assert.assertEquals((long)2L, (long)((PostCountByYear)postCountByYearMap.get(0)).getPostCount());
            Assert.assertEquals((long)2018L, (long)((PostCountByYear)postCountByYearMap.get(1)).getYear());
            Assert.assertEquals((long)2L, (long)((PostCountByYear)postCountByYearMap.get(1)).getPostCount());
            Assert.assertEquals((long)2019L, (long)((PostCountByYear)postCountByYearMap.get(2)).getYear());
            Assert.assertEquals((long)1L, (long)((PostCountByYear)postCountByYearMap.get(2)).getPostCount());
        });
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @Id
        private Long id;
        private String title;
        @Column(name="created_on")
        private LocalDate createdOn;

        public Long getId() {
            return this.id;
        }

        public Post setId(Long id) {
            this.id = id;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Post setTitle(String title) {
            this.title = title;
            return this;
        }

        public LocalDate getCreatedOn() {
            return this.createdOn;
        }

        public Post setCreatedOn(LocalDate createdOn) {
            this.createdOn = createdOn;
            return this;
        }
    }

    public static class PostCountByYear {
        private final int year;
        private final int postCount;

        public PostCountByYear(int year, int postCount) {
            this.year = year;
            this.postCount = postCount;
        }

        public int getYear() {
            return this.year;
        }

        public int getPostCount() {
            return this.postCount;
        }
    }
}

