/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import io.hypersistence.utils.hibernate.query.DistinctListTransformer;
import io.hypersistence.utils.hibernate.util.AbstractTest;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.query.Query;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.junit.Assert;
import org.junit.Test;

public class DistinctListTransformerTest
extends AbstractTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class, PostComment.class};
    }

    @Override
    public void afterInit() {
        this.doInJPA(entityManager -> {
            entityManager.persist((Object)new Post().setId(1L).setTitle("High-Performance Java Persistence").setCreatedBy("Vlad Mihalcea").setCreatedOn(LocalDateTime.of(2016, 11, 2, 12, 0, 0)).setUpdatedBy("Vlad Mihalcea").setUpdatedOn(LocalDateTime.now()).addComment(new PostComment().setId(1L).setReview("Best book on JPA and Hibernate!")).addComment(new PostComment().setId(2L).setReview("A must-read for every Java developer!")));
            entityManager.persist((Object)new Post().setId(2L).setTitle("Hypersistence Optimizer").setCreatedBy("Vlad Mihalcea").setCreatedOn(LocalDateTime.of(2019, 3, 19, 12, 0, 0)).setUpdatedBy("Vlad Mihalcea").setUpdatedOn(LocalDateTime.now()).addComment(new PostComment().setId(3L).setReview("It's like pair programming with Vlad!")));
        });
    }

    @Test
    public void testParentChildDTOProjectionNativeQueryTupleTransformer() {
        this.doInJPA(entityManager -> {
            List postDTOs = ((Query)entityManager.createNativeQuery("SELECT p.id AS p_id,        p.title AS p_title,        pc.id AS pc_id,        pc.review AS pc_review FROM post p JOIN post_comment pc ON p.id = pc.post_id ORDER BY pc.id").unwrap(Query.class)).setTupleTransformer((TupleTransformer)new PostDTOTupleTransformer()).setResultListTransformer((ResultListTransformer)DistinctListTransformer.INSTANCE).getResultList();
            Assert.assertEquals((long)2L, (long)postDTOs.size());
            Assert.assertEquals((long)2L, (long)((PostDTO)postDTOs.get(0)).getComments().size());
            Assert.assertEquals((long)1L, (long)((PostDTO)postDTOs.get(1)).getComments().size());
            PostDTO post1DTO = (PostDTO)postDTOs.get(0);
            Assert.assertEquals((long)1L, (long)post1DTO.getId());
            Assert.assertEquals((long)2L, (long)post1DTO.getComments().size());
            Assert.assertEquals((long)1L, (long)post1DTO.getComments().get(0).getId());
            Assert.assertEquals((long)2L, (long)post1DTO.getComments().get(1).getId());
            PostDTO post2DTO = (PostDTO)postDTOs.get(1);
            Assert.assertEquals((long)2L, (long)post2DTO.getId());
            Assert.assertEquals((long)1L, (long)post2DTO.getComments().size());
            Assert.assertEquals((long)3L, (long)post2DTO.getComments().get(0).getId());
        });
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @Id
        private Long id;
        private String title;
        @Column(name="created_on")
        private LocalDateTime createdOn;
        @Column(name="created_by")
        private String createdBy;
        @Column(name="updated_on")
        private LocalDateTime updatedOn;
        @Column(name="updated_by")
        private String updatedBy;
        @Version
        private Short version;
        @OneToMany(mappedBy="post", cascade={CascadeType.ALL}, orphanRemoval=true)
        private List<PostComment> comments = new ArrayList<PostComment>();

        public Long getId() {
            return this.id;
        }

        public Post setId(Long id) {
            this.id = id;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Post setTitle(String title) {
            this.title = title;
            return this;
        }

        public LocalDateTime getCreatedOn() {
            return this.createdOn;
        }

        public Post setCreatedOn(LocalDateTime createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public Post setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public LocalDateTime getUpdatedOn() {
            return this.updatedOn;
        }

        public Post setUpdatedOn(LocalDateTime updatedOn) {
            this.updatedOn = updatedOn;
            return this;
        }

        public String getUpdatedBy() {
            return this.updatedBy;
        }

        public Post setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public Short getVersion() {
            return this.version;
        }

        public Post setVersion(Short version) {
            this.version = version;
            return this;
        }

        public List<PostComment> getComments() {
            return this.comments;
        }

        public Post addComment(PostComment comment) {
            this.comments.add(comment);
            comment.setPost(this);
            return this;
        }
    }

    @Entity
    @Table(name="post_comment")
    public static class PostComment {
        @Id
        private Long id;
        @ManyToOne(fetch=FetchType.LAZY)
        private Post post;
        private String review;

        public Long getId() {
            return this.id;
        }

        public PostComment setId(Long id) {
            this.id = id;
            return this;
        }

        public Post getPost() {
            return this.post;
        }

        public PostComment setPost(Post post) {
            this.post = post;
            return this;
        }

        public String getReview() {
            return this.review;
        }

        public PostComment setReview(String review) {
            this.review = review;
            return this;
        }
    }

    public static class PostDTOTupleTransformer
    implements TupleTransformer {
        private Map<Long, PostDTO> postDTOMap = new LinkedHashMap<Long, PostDTO>();

        public PostDTO transformTuple(Object[] tuple, String[] aliases) {
            Map<String, Integer> aliasToIndexMap = this.aliasToIndexMap(aliases);
            Long postId = AbstractTest.longValue(tuple[aliasToIndexMap.get("p_id")]);
            PostDTO postDTO = this.postDTOMap.computeIfAbsent(postId, id -> new PostDTO(tuple, aliasToIndexMap));
            postDTO.getComments().add(new PostCommentDTO(tuple, aliasToIndexMap));
            return postDTO;
        }

        private Map<String, Integer> aliasToIndexMap(String[] aliases) {
            LinkedHashMap<String, Integer> aliasToIndexMap = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < aliases.length; ++i) {
                aliasToIndexMap.put(aliases[i].toLowerCase(Locale.ROOT), i);
            }
            return aliasToIndexMap;
        }
    }

    public static class PostDTO {
        public static final String ID_ALIAS = "p_id";
        public static final String TITLE_ALIAS = "p_title";
        private Long id;
        private String title;
        private List<PostCommentDTO> comments = new ArrayList<PostCommentDTO>();

        public PostDTO() {
        }

        public PostDTO(Long id, String title) {
            this.id = id;
            this.title = title;
        }

        public PostDTO(Object[] tuples, Map<String, Integer> aliasToIndexMap) {
            this.id = AbstractTest.longValue(tuples[aliasToIndexMap.get(ID_ALIAS)]);
            this.title = AbstractTest.stringValue(tuples[aliasToIndexMap.get(TITLE_ALIAS)]);
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Number id) {
            this.id = id.longValue();
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<PostCommentDTO> getComments() {
            return this.comments;
        }
    }

    public static class PostCommentDTO {
        public static final String ID_ALIAS = "pc_id";
        public static final String REVIEW_ALIAS = "pc_review";
        private Long id;
        private String review;

        public PostCommentDTO(Long id, String review) {
            this.id = id;
            this.review = review;
        }

        public PostCommentDTO(Object[] tuples, Map<String, Integer> aliasToIndexMap) {
            this.id = AbstractTest.longValue(tuples[aliasToIndexMap.get(ID_ALIAS)]);
            this.review = AbstractTest.stringValue(tuples[aliasToIndexMap.get(REVIEW_ALIAS)]);
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Number id) {
            this.id = id.longValue();
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getReview() {
            return this.review;
        }

        public void setReview(String review) {
            this.review = review;
        }
    }
}

