/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.naming;

import io.hypersistence.utils.hibernate.naming.CamelCaseToSnakeCaseNamingStrategy;
import io.hypersistence.utils.hibernate.util.AbstractTest;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.time.LocalDate;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.junit.Assert;
import org.junit.Test;

public class CamelCaseToSnakeCaseNamingStrategyTest
extends AbstractTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{BookAuthor.class, PaperBackBook.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.physical_naming_strategy", CamelCaseToSnakeCaseNamingStrategy.INSTANCE);
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            BookAuthor author = new BookAuthor();
            author.setId(1L);
            author.setFirstName("Vlad");
            author.setLastName("Mihalcea");
            entityManager.persist((Object)author);
            PaperBackBook book = new PaperBackBook();
            book.setISBN("978-9730228236");
            book.setTitle("High-Performance Java Persistence");
            book.setPublishedOn(LocalDate.of(2016, 10, 12));
            book.setPublishedBy(author);
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            PaperBackBook book = (PaperBackBook)session.bySimpleNaturalId(PaperBackBook.class).load((Object)"978-9730228236");
            Assert.assertEquals((Object)"High-Performance Java Persistence", (Object)book.getTitle());
            Assert.assertEquals((Object)"Vlad Mihalcea", (Object)book.getPublishedBy().getFullName());
        });
    }

    @Entity(name="BookAuthor")
    public static class BookAuthor {
        @Id
        private Long id;
        private String firstName;
        private String lastName;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFullName() {
            return this.firstName + " " + this.lastName;
        }
    }

    @Entity(name="PaperBackBook")
    public static class PaperBackBook {
        @Id
        @GeneratedValue(strategy=GenerationType.SEQUENCE)
        private Long id;
        @NaturalId
        private String ISBN;
        private String title;
        private LocalDate publishedOn;
        @ManyToOne(fetch=FetchType.LAZY)
        private BookAuthor publishedBy;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getISBN() {
            return this.ISBN;
        }

        public void setISBN(String ISBN) {
            this.ISBN = ISBN;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public LocalDate getPublishedOn() {
            return this.publishedOn;
        }

        public void setPublishedOn(LocalDate publishedOn) {
            this.publishedOn = publishedOn;
        }

        public BookAuthor getPublishedBy() {
            return this.publishedBy;
        }

        public void setPublishedBy(BookAuthor publishedBy) {
            this.publishedBy = publishedBy;
        }
    }
}

