/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.id;

import io.hypersistence.utils.hibernate.util.AbstractTest;
import io.hypersistence.utils.hibernate.util.providers.DataSourceProvider;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Properties;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractBatchSequenceGeneratorTest
extends AbstractTest {
    private static final int BATCH_SIZE = 50;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class};
    }

    @Override
    protected abstract DataSourceProvider dataSourceProvider();

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.jdbc.batch_versioned_data", (Object)true);
        properties.put("hibernate.jdbc.batch_size", (Object)50);
        properties.put("hibernate.order_updates", (Object)true);
        properties.put("hibernate.order_inserts", (Object)true);
    }

    @Test
    public void test() {
        QueryCountHolder.clear();
        this.doInJPA(entityManager -> {
            for (int i = 0; i < 50; ++i) {
                Post post = new Post();
                post.setTitle("Post " + i + "1");
                entityManager.persist((Object)post);
            }
        });
        QueryCount queryCount = QueryCountHolder.getGrandTotal();
        Assert.assertEquals((long)1L, (long)queryCount.getInsert());
        Assert.assertEquals((long)1L, (long)this.getSelectCount(queryCount));
        Assert.assertEquals((long)2L, (long)queryCount.getTotal());
        this.doInJPA(entityManager -> {
            List posts = entityManager.createQuery("SELECT p FROM Post p", Post.class).getResultList();
            Assert.assertEquals((long)50L, (long)posts.size());
        });
    }

    protected long getSelectCount(QueryCount queryCount) {
        switch (this.dataSourceProvider().database()) {
            case ORACLE: 
            case POSTGRESQL: {
                return queryCount.getSelect();
            }
            case SQLSERVER: 
            case H2: {
                return queryCount.getOther();
            }
        }
        throw new UnsupportedOperationException("Unsupported database: " + this.dataSourceProvider().database());
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @Id
        @GenericGenerator(name="post_sequence", strategy="io.hypersistence.utils.hibernate.id.BatchSequenceGenerator", parameters={@Parameter(name="sequence", value="SEQ_PARENT_ID"), @Parameter(name="fetch_size", value="50")})
        @GeneratedValue(generator="post_sequence")
        private Long id;
        private String title;

        public Long getId() {
            return this.id;
        }

        public Post setId(Long id) {
            this.id = id;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Post setTitle(String title) {
            this.title = title;
            return this;
        }
    }
}

