/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.statistics.StatisticsSummary;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface Client {
    public BenchmarkRef register(Benchmark var1);

    public List<String> benchmarks();

    public BenchmarkRef benchmark(String var1);

    public List<String> runs();

    public RunRef run(String var1);

    public long ping();

    public Collection<String> agents();

    public String downloadLog(String var1, String var2, long var3, String var5);

    public static class CustomStats {
        public final String phase;
        public final int stepId;
        public final String metric;
        public final String customName;
        public final String value;

        @JsonCreator
        public CustomStats(@JsonProperty(value="phase") String phase, @JsonProperty(value="stepId") int stepId, @JsonProperty(value="metric") String metric, @JsonProperty(value="customName") String customName, @JsonProperty(value="value") String value) {
            this.phase = phase;
            this.stepId = stepId;
            this.metric = metric;
            this.customName = customName;
            this.value = value;
        }
    }

    public static class RequestStats {
        public final String phase;
        public final String metric;
        public final StatisticsSummary summary;
        public final List<String> failedSLAs;

        @JsonCreator
        public RequestStats(@JsonProperty(value="phase") String phase, @JsonProperty(value="metric") String metric, @JsonProperty(value="summary") StatisticsSummary summary, @JsonProperty(value="failedSLAs") List<String> failedSLAs) {
            this.phase = phase;
            this.metric = metric;
            this.summary = summary;
            this.failedSLAs = failedSLAs;
        }
    }

    public static class RequestStatisticsResponse {
        public final String status;
        public final List<RequestStats> statistics;

        @JsonCreator
        public RequestStatisticsResponse(@JsonProperty(value="status") String status, @JsonProperty(value="statistics") List<RequestStats> statistics) {
            this.status = status;
            this.statistics = statistics;
        }
    }

    public static class MinMax {
        public final int min;
        public final int max;

        @JsonCreator
        public MinMax(@JsonProperty(value="min") int min, @JsonProperty(value="max") int max) {
            this.min = min;
            this.max = max;
        }
    }

    public static class Run {
        public final String id;
        public final String benchmark;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy/MM/dd HH:mm:ss.S")
        public final Date started;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy/MM/dd HH:mm:ss.S")
        public final Date terminated;
        public final String description;
        public final Collection<Phase> phases;
        public final Collection<Agent> agents;
        public final Collection<String> errors;

        @JsonCreator
        public Run(@JsonProperty(value="id") String id, @JsonProperty(value="benchmark") String benchmark, @JsonProperty(value="started") Date started, @JsonProperty(value="terminated") Date terminated, @JsonProperty(value="description") String description, @JsonProperty(value="phases") Collection<Phase> phases, @JsonProperty(value="agents") Collection<Agent> agents, @JsonProperty(value="errors") Collection<String> errors) {
            this.id = id;
            this.benchmark = benchmark;
            this.started = started;
            this.terminated = terminated;
            this.description = description;
            this.phases = phases;
            this.agents = agents;
            this.errors = errors;
        }
    }

    public static class Phase {
        public final String name;
        public final String status;
        public final String type;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy/MM/dd HH:mm:ss.S")
        public final Date started;
        public final String remaining;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy/MM/dd HH:mm:ss.S")
        public final Date completed;
        public final String totalDuration;
        public final String description;

        @JsonCreator
        public Phase(@JsonProperty(value="name") String name, @JsonProperty(value="status") String status, @JsonProperty(value="type") String type, @JsonProperty(value="started") Date started, @JsonProperty(value="remaining") String remaining, @JsonProperty(value="completed") Date completed, @JsonProperty(value="totalDuration") String totalDuration, @JsonProperty(value="description") String description) {
            this.name = name;
            this.status = status;
            this.type = type;
            this.started = started;
            this.remaining = remaining;
            this.completed = completed;
            this.totalDuration = totalDuration;
            this.description = description;
        }
    }

    public static class Agent {
        public final String name;
        public final String address;
        public final String status;

        @JsonCreator
        public Agent(@JsonProperty(value="name") String name, @JsonProperty(value="address") String address, @JsonProperty(value="status") String status) {
            this.name = name;
            this.address = address;
            this.status = status;
        }
    }

    public static interface RunRef {
        public String id();

        public Run get();

        public RunRef kill();

        public Benchmark benchmark();

        public Map<String, Map<String, MinMax>> sessionStatsRecent();

        public Map<String, Map<String, MinMax>> sessionStatsTotal();

        public Collection<String> sessions();

        public Collection<String> connections();

        public RequestStatisticsResponse statsRecent();

        public RequestStatisticsResponse statsTotal();

        public Collection<CustomStats> customStats();
    }

    public static interface BenchmarkRef {
        public String name();

        public Benchmark get();

        public RunRef start();
    }
}

