/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import io.hyperfoil.api.statistics.CustomValue;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.HdrHistogram.WriterReaderPhaser;

public class Statistics {
    private static final Logger log = LoggerFactory.getLogger(Statistics.class);
    private static final long SAMPLING_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final AtomicIntegerFieldUpdater<Statistics> LU1 = AtomicIntegerFieldUpdater.newUpdater(Statistics.class, "lowestActive1");
    private static final AtomicIntegerFieldUpdater<Statistics> LU2 = AtomicIntegerFieldUpdater.newUpdater(Statistics.class, "lowestActive2");
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private final long highestTrackableValue;
    private int numSamples = 4;
    private volatile int lowestActive1;
    private volatile int lowestActive2;
    private volatile int highestActive;
    private volatile AtomicIntegerFieldUpdater<Statistics> lowestActiveUpdater = LU1;
    private volatile AtomicReferenceArray<StatisticsSnapshot> active;
    private AtomicReferenceArray<StatisticsSnapshot> inactive;
    private long startTimestamp;
    private long endTimestamp = Long.MAX_VALUE;
    private int lastLowestIndex;

    public Statistics(long startTimestamp) {
        this.startTimestamp = startTimestamp;
        this.active = new AtomicReferenceArray(16);
        this.inactive = new AtomicReferenceArray(16);
        StatisticsSnapshot first = new StatisticsSnapshot();
        first.sequenceId = 0;
        first.histogram.setStartTimeStamp(startTimestamp);
        first.histogram.setEndTimeStamp(startTimestamp + SAMPLING_PERIOD_MILLIS);
        this.active.set(0, first);
        this.highestTrackableValue = first.histogram.getHighestTrackableValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(long startTimestamp, long sendTime, long responseTime) {
        if (responseTime > this.highestTrackableValue) {
            log.warn((Object)"Response time {} exceeded maximum trackable response time {}", new Object[]{responseTime, this.highestTrackableValue});
            responseTime = this.highestTrackableValue;
        }
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(startTimestamp);
            active.histogram.recordValue(responseTime);
            active.totalSendTime += sendTime;
            ++active.responseCount;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRequests(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.requestCount;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTimeouts(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.timeouts;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementResets(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.resetCount;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBlockedCount(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.blockedCount;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBlockedTime(long timestamp, long blockedTime) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            active.blockedTime += blockedTime;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addStatus(long timestamp, int code) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            switch (code / 100) {
                case 2: {
                    ++active.status_2xx;
                    return;
                }
                case 3: {
                    ++active.status_3xx;
                    return;
                }
                case 4: {
                    ++active.status_4xx;
                    return;
                }
                case 5: {
                    ++active.status_5xx;
                    return;
                }
                default: {
                    ++active.status_other;
                    return;
                }
            }
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CustomValue> T getCustom(long timestamp, Object key, Supplier<T> identitySupplier) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            CustomValue custom = active.custom.get(key);
            if (custom == null) {
                custom = (CustomValue)identitySupplier.get();
                active.custom.put(key, custom);
            }
            CustomValue customValue = custom;
            return (T)customValue;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalid(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.invalid;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheHit(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.cacheHits;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSnapshots(Consumer<StatisticsSnapshot> consumer) {
        try {
            this.recordingPhaser.readerLock();
            if (++this.numSamples >= this.inactive.length()) {
                AtomicReferenceArray<StatisticsSnapshot> temp = new AtomicReferenceArray<StatisticsSnapshot>(this.inactive.length() * 2);
                for (int i = this.lastLowestIndex; i < this.inactive.length(); ++i) {
                    temp.set(i, this.inactive.get(i));
                }
                this.inactive = temp;
            }
            for (int i = this.lastLowestIndex; i < this.numSamples; ++i) {
                StatisticsSnapshot snapshot = this.inactive.get(i);
                if (snapshot == null) continue;
                snapshot.reset();
                snapshot.histogram.setStartTimeStamp(this.startTimestamp + (long)i * SAMPLING_PERIOD_MILLIS);
                snapshot.histogram.setEndTimeStamp(this.startTimestamp + (long)(i + 1) * SAMPLING_PERIOD_MILLIS);
            }
            AtomicReferenceArray<StatisticsSnapshot> tempHistogram = this.inactive;
            this.inactive = this.active;
            this.active = tempHistogram;
            AtomicIntegerFieldUpdater<Statistics> inactiveUpdater = this.lowestActiveUpdater;
            this.lowestActiveUpdater = inactiveUpdater == LU1 ? LU2 : LU1;
            this.recordingPhaser.flipPhase(500000L);
            this.lastLowestIndex = Math.min(LU1.get(this), LU2.get(this));
            inactiveUpdater.set(this, Integer.MAX_VALUE);
            int maxSamples = Math.min(this.inactive.length(), this.highestActive + 1);
            for (int i = this.lastLowestIndex; i < maxSamples; ++i) {
                StatisticsSnapshot snapshot = this.inactive.get(i);
                if (snapshot == null) continue;
                if (snapshot.isEmpty()) {
                    this.inactive.set(i, null);
                    continue;
                }
                consumer.accept(snapshot);
            }
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public void start(long now) {
        this.recordingPhaser.readerLock();
        try {
            this.startTimestamp = now;
            this.endTimestamp = Long.MAX_VALUE;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public void end(long now) {
        this.recordingPhaser.readerLock();
        try {
            this.endTimestamp = now;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private StatisticsSnapshot active(long timestamp) {
        StatisticsSnapshot snapshot;
        int sample = (int)((timestamp - this.startTimestamp) / SAMPLING_PERIOD_MILLIS);
        int index = sample;
        AtomicReferenceArray<StatisticsSnapshot> active = this.active;
        if (index >= active.length()) {
            index = active.length() - 1;
        }
        if ((snapshot = active.get(index)) == null) {
            snapshot = new StatisticsSnapshot();
            snapshot.histogram.setStartTimeStamp(this.startTimestamp + (long)index * SAMPLING_PERIOD_MILLIS);
            snapshot.histogram.setEndTimeStamp(this.startTimestamp + (long)(index + 1) * SAMPLING_PERIOD_MILLIS);
            snapshot.sequenceId = index;
            active.set(index, snapshot);
        }
        if (sample != index) {
            snapshot.histogram.setEndTimeStamp(this.startTimestamp + (long)(sample + 1) * SAMPLING_PERIOD_MILLIS);
        }
        this.lowestActiveUpdater.accumulateAndGet(this, index, Math::min);
        if (index > this.highestActive) {
            this.highestActive = index;
        }
        return snapshot;
    }
}

