/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.statistics.Statistics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;

public class SessionStatistics
implements Iterable<Statistics> {
    private Phase[] phases = new Phase[4];
    private int[] stepIds = new int[4];
    private Map<String, Statistics>[] maps = new Map[4];
    private int size;

    @Override
    public Iterator<Statistics> iterator() {
        return new It();
    }

    public Statistics getOrCreate(Phase phase, int stepId, String name, long startTime) {
        for (int i = 0; i < this.size; ++i) {
            if (this.stepIds[i] != stepId || this.phases[i] != phase) continue;
            Statistics s = this.maps[i].get(name);
            if (s == null) {
                s = new Statistics(startTime);
                this.maps[i].put(name, s);
            }
            return s;
        }
        if (this.size == this.stepIds.length) {
            this.phases = Arrays.copyOf(this.phases, this.size * 2);
            this.stepIds = Arrays.copyOf(this.stepIds, this.size * 2);
            this.maps = Arrays.copyOf(this.maps, this.size * 2);
        }
        this.phases[this.size] = phase;
        this.stepIds[this.size] = stepId;
        Statistics s = new Statistics(startTime);
        HashMap<String, Statistics> map = new HashMap<String, Statistics>();
        map.put(name, s);
        this.maps[this.size] = map;
        ++this.size;
        return s;
    }

    public int size() {
        return this.size;
    }

    public Phase phase(int index) {
        return this.phases[index];
    }

    public int step(int index) {
        return this.stepIds[index];
    }

    public Map<String, Statistics> stats(int index) {
        return this.maps[index];
    }

    public Stream<Map<String, Statistics>> maps() {
        return Stream.of(this.maps).filter(Objects::nonNull);
    }

    public void prune(Phase phase) {
        int lastGood;
        for (lastGood = this.size - 1; lastGood >= 0 && this.phases[lastGood] == phase; --lastGood) {
        }
        int lastSize = this.size;
        for (int i = 0; i < lastSize; ++i) {
            if (this.phases[i] != phase) continue;
            if (lastGood > i) {
                this.phases[i] = this.phases[lastGood];
                this.stepIds[i] = this.stepIds[lastGood];
                this.maps[i] = this.maps[lastGood];
                while (lastGood > i && this.phases[lastGood] == phase) {
                    --lastGood;
                }
            } else {
                this.phases[i] = null;
                this.stepIds[i] = 0;
                this.maps[i] = null;
            }
            --this.size;
        }
    }

    private class It
    implements Iterator<Statistics> {
        int i;
        Iterator<Statistics> it;

        private It() {
        }

        @Override
        public boolean hasNext() {
            if (this.it != null && this.it.hasNext()) {
                return true;
            }
            while (this.i < SessionStatistics.this.maps.length && SessionStatistics.this.maps[this.i] != null) {
                this.it = SessionStatistics.this.maps[this.i].values().iterator();
                ++this.i;
                if (!this.it.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Statistics next() {
            if (this.it != null && this.it.hasNext()) {
                return this.it.next();
            }
            while (this.i < SessionStatistics.this.maps.length && SessionStatistics.this.maps[this.i] != null) {
                this.it = SessionStatistics.this.maps[this.i].values().iterator();
                ++this.i;
                if (!this.it.hasNext()) continue;
                return this.it.next();
            }
            throw new NoSuchElementException();
        }
    }
}

