/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.session;

import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Session;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class SequenceInstance {
    private static final Logger log = LoggerFactory.getLogger(SequenceInstance.class);
    private static final boolean trace = log.isTraceEnabled();
    private String name;
    private int sourceId;
    private int index;
    private Step[] steps;
    private int currentStep = 0;
    private long blockedTimestamp = Long.MIN_VALUE;

    public boolean progress(Session session) {
        boolean progressed = false;
        while (this.currentStep < this.steps.length) {
            Step step = this.steps[this.currentStep];
            if (trace) {
                log.trace((Object)"#{} {}({}) invoking step {}", new Object[]{session.uniqueId(), this.name, this.index, step});
            }
            try {
                if (!step.invoke(session)) {
                    if (trace) {
                        log.trace((Object)"#{} {}({}) step {} is blocked", new Object[]{session.uniqueId(), this.name, this.index, step});
                    }
                    return progressed;
                }
            }
            catch (Throwable t) {
                log.error((Object)"#{} {}({}) failure invoking step {}", t, new Object[]{session.uniqueId(), this.name, this.index, step});
                session.fail(t);
                return false;
            }
            this.currentStep = session.currentSequence() != null ? ++this.currentStep : this.steps.length;
            progressed = true;
        }
        return progressed;
    }

    public SequenceInstance reset(String name, int sourceId, int index, Step[] steps) {
        this.name = name;
        this.sourceId = sourceId;
        this.index = index;
        this.steps = steps;
        this.currentStep = 0;
        return this;
    }

    public boolean isCompleted() {
        return this.currentStep >= this.steps.length;
    }

    public int index() {
        return this.index;
    }

    public String name() {
        return this.name;
    }

    public void setBlockedTimestamp() {
        this.blockedTimestamp = System.nanoTime();
    }

    public long getBlockedTime() {
        long blockedTimestamp = this.blockedTimestamp;
        if (blockedTimestamp == Long.MIN_VALUE) {
            return 0L;
        }
        this.blockedTimestamp = Long.MIN_VALUE;
        return System.nanoTime() - blockedTimestamp;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder sb) {
        return sb.append(this.name).append('(').append(this.index).append(")(").append(this.currentStep).append('/').append(this.steps.length).append(')');
    }
}

