/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.connection;

import io.hyperfoil.api.config.ServiceLoadedFactory;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.connection.Processor;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.statistics.Statistics;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class Request
implements Callable<Void>,
GenericFutureListener<Future<Void>> {
    private static final TimeoutException TIMEOUT_EXCEPTION = new TimeoutException();
    public final Session session;
    private long startTimestampMillis;
    private long startTimestampNanos;
    private long sendTimestampNanos;
    private SequenceInstance sequence;
    private Statistics statistics;
    private ScheduledFuture<?> timeoutFuture;
    private Connection connection;
    private boolean completed = true;
    private boolean valid = true;

    public Request(Session session) {
        this.session = session;
    }

    @Override
    public Void call() {
        this.timeoutFuture = null;
        if (!this.isCompleted()) {
            this.statistics.incrementTimeouts(this.startTimestampNanos);
            this.handleThrowable(TIMEOUT_EXCEPTION);
        }
        return null;
    }

    protected abstract void handleThrowable(Throwable var1);

    public void start(SequenceInstance sequence, Statistics statistics) {
        this.startTimestampMillis = System.currentTimeMillis();
        this.startTimestampNanos = System.nanoTime();
        this.sequence = sequence;
        this.statistics = statistics;
        this.completed = false;
    }

    public void attach(Connection connection) {
        this.connection = connection;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void markInvalid() {
        this.valid = false;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
        this.connection = null;
        this.completed = true;
        this.valid = true;
    }

    public Connection connection() {
        return this.connection;
    }

    public SequenceInstance sequence() {
        return this.sequence;
    }

    public Statistics statistics() {
        return this.statistics;
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public long startTimestampNanos() {
        return this.startTimestampNanos;
    }

    public long sendTimestampNanos() {
        return this.sendTimestampNanos;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeoutFuture = this.session.executor().schedule((Callable)this, timeout, timeUnit);
    }

    public void operationComplete(Future<Void> future) {
        this.sendTimestampNanos = System.nanoTime();
    }

    public static interface ProcessorBuilderFactory
    extends ServiceLoadedFactory<Processor.Builder<Request>> {
    }
}

