/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.connection;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;

public interface Processor<R extends Request>
extends Serializable {
    default public void before(R request) {
    }

    public void process(R var1, ByteBuf var2, int var3, int var4, boolean var5);

    default public void after(R request) {
    }

    public static abstract class BaseDelegating<R extends Request>
    implements Processor<R>,
    ResourceUtilizer {
        protected final Processor<R> delegate;

        protected BaseDelegating(Processor<R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void before(R request) {
            this.delegate.before(request);
        }

        @Override
        public void after(R request) {
            this.delegate.after(request);
        }

        @Override
        public void reserve(Session session) {
            if (this.delegate instanceof ResourceUtilizer) {
                ((ResourceUtilizer)((Object)this.delegate)).reserve(session);
            }
        }
    }

    public static interface Builder<R extends Request>
    extends BuilderBase<Builder<R>> {
        public Processor<R> build();
    }
}

