/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableSupplier;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

class SequenceImpl
implements Sequence {
    private static final Logger log = LoggerFactory.getLogger(SequenceImpl.class);
    private final SerializableSupplier<Phase> phase;
    private final String name;
    private final int id;
    private final Step[] steps;

    public SequenceImpl(SerializableSupplier<Phase> phase, String name, int id, Step[] steps) {
        this.phase = phase;
        this.name = name;
        this.id = id;
        this.steps = steps;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public void instantiate(Session session, int index) {
        SequenceInstance instance = session.acquireSequence();
        if (instance == null) {
            log.error((Object)"Cannot instantiate sequence {}({}), no free instances.", new Object[]{this.name, this.id});
            session.fail(new IllegalStateException("No free sequence instances"));
        } else {
            instance.reset(this.name, this.id, index, this.steps);
            session.enableSequence(instance);
        }
    }

    @Override
    public void reserve(Session session) {
        for (Step a : this.steps) {
            if (!(a instanceof ResourceUtilizer)) continue;
            ((ResourceUtilizer)((Object)a)).reserve(session);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Phase phase() {
        return (Phase)this.phase.get();
    }

    @Override
    public Step[] steps() {
        return this.steps;
    }
}

