/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.SequenceImpl;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableSupplier;
import io.hyperfoil.impl.FutureSupplier;
import java.util.ArrayList;
import java.util.Objects;

public class SequenceBuilder
extends BaseSequenceBuilder {
    private final ScenarioBuilder scenario;
    private final String name;
    private int id;
    private Sequence sequence;
    private String nextSequence;

    SequenceBuilder(ScenarioBuilder scenario, String name) {
        super(null);
        this.scenario = scenario;
        this.name = Objects.requireNonNull(name);
    }

    SequenceBuilder(ScenarioBuilder scenario, SequenceBuilder other) {
        super(null);
        this.scenario = scenario;
        this.name = other.name;
        this.readFrom(other);
        this.nextSequence = other.nextSequence;
    }

    public void prepareBuild() {
        String nextSequence = this.nextSequence;
        if (nextSequence != null) {
            this.step((Session s) -> {
                s.nextSequence(nextSequence);
                return true;
            });
        }
        new ArrayList<StepBuilder>(this.steps).forEach(StepBuilder::prepareBuild);
    }

    public Sequence build(SerializableSupplier<Phase> phase) {
        if (this.sequence != null) {
            return this.sequence;
        }
        FutureSupplier<Sequence> ss = new FutureSupplier<Sequence>();
        this.sequence = new SequenceImpl(phase, this.name, this.id, this.buildSteps(ss).toArray(new Step[0]));
        ss.set(this.sequence);
        return this.sequence;
    }

    void id(int id) {
        this.id = id;
    }

    @Override
    public SequenceBuilder end() {
        return this;
    }

    @Override
    public ScenarioBuilder endSequence() {
        return this.scenario;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void nextSequence(String nextSequence) {
        this.nextSequence = nextSequence;
    }
}

