/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.function.SerializableSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class ScenarioBuilder
implements Rewritable<ScenarioBuilder> {
    private final PhaseBuilder<?> phaseBuilder;
    private Collection<SequenceBuilder> initialSequences = new ArrayList<SequenceBuilder>();
    private Collection<SequenceBuilder> sequences = new ArrayList<SequenceBuilder>();
    private Collection<String> objectVars = new ArrayList<String>();
    private Collection<String> intVars = new ArrayList<String>();
    private Scenario scenario;

    ScenarioBuilder(PhaseBuilder<?> phaseBuilder) {
        this.phaseBuilder = phaseBuilder;
    }

    public PhaseBuilder endScenario() {
        return this.phaseBuilder;
    }

    ScenarioBuilder initialSequence(SequenceBuilder sequence) {
        this.initialSequences.add(sequence);
        sequence.id(this.sequences.size());
        this.sequences.add(sequence);
        return this;
    }

    public SequenceBuilder initialSequence(String name) {
        SequenceBuilder builder = new SequenceBuilder(this, name);
        this.initialSequence(builder);
        return builder;
    }

    ScenarioBuilder sequence(SequenceBuilder sequence) {
        sequence.id(this.sequences.size());
        this.sequences.add(sequence);
        return this;
    }

    public SequenceBuilder sequence(String name) {
        SequenceBuilder builder = new SequenceBuilder(this, name);
        this.sequence(builder);
        return builder;
    }

    public SequenceBuilder findSequence(String name) {
        return this.sequences.stream().filter(sb -> name.equals(sb.name())).findFirst().orElseThrow(() -> new BenchmarkDefinitionException("No sequence " + name + " in phase " + this.endScenario().name()));
    }

    public ScenarioBuilder objectVar(String var) {
        assert (this.scenario == null);
        this.objectVars.add(var);
        return this;
    }

    public ScenarioBuilder intVar(String var) {
        assert (this.scenario == null);
        this.intVars.add(var);
        return this;
    }

    public void prepareBuild() {
        new ArrayList<SequenceBuilder>(this.sequences).forEach(SequenceBuilder::prepareBuild);
    }

    public Scenario build(SerializableSupplier<Phase> phase) {
        if (this.scenario != null) {
            return this.scenario;
        }
        if (this.initialSequences.isEmpty()) {
            throw new BenchmarkDefinitionException("No initial sequences in phase " + this.endScenario().name());
        }
        this.scenario = new Scenario((Sequence[])this.initialSequences.stream().map(sequenceBuilder -> sequenceBuilder.build(phase)).toArray(Sequence[]::new), (Sequence[])this.sequences.stream().map(sequenceBuilder1 -> sequenceBuilder1.build(phase)).toArray(Sequence[]::new), this.objectVars.toArray(new String[0]), this.intVars.toArray(new String[0]));
        return this.scenario;
    }

    @Override
    public void readFrom(ScenarioBuilder other) {
        this.sequences = other.sequences.stream().map(seq -> new SequenceBuilder(this, (SequenceBuilder)seq)).collect(Collectors.toList());
        this.initialSequences = other.initialSequences.stream().map(seq -> this.findMatchingSequence(seq.name())).collect(Collectors.toList());
        this.intVars = other.intVars;
        this.objectVars = other.objectVars;
    }

    private SequenceBuilder findMatchingSequence(String name) {
        return this.sequences.stream().filter(s2 -> s2.name().equals(name)).findFirst().orElseThrow(IllegalStateException::new);
    }

    Collection<SequenceBuilder> sequences() {
        return this.sequences;
    }
}

