/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Sequence;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Scenario
implements Serializable {
    private final Sequence[] initialSequences;
    private final Sequence[] sequences;
    private final String[] objectVars;
    private final String[] intVars;
    private final Map<String, Sequence> sequenceMap;

    public Scenario(Sequence[] initialSequences, Sequence[] sequences, String[] objectVars, String[] intVars) {
        this.initialSequences = initialSequences;
        this.sequences = sequences;
        this.objectVars = objectVars;
        this.intVars = intVars;
        this.sequenceMap = Stream.of(sequences).collect(Collectors.toMap(s -> s.name(), Function.identity()));
    }

    public Sequence[] initialSequences() {
        return this.initialSequences;
    }

    public Sequence[] sequences() {
        return this.sequences;
    }

    public String[] objectVars() {
        return this.objectVars;
    }

    public String[] intVars() {
        return this.intVars;
    }

    public int maxRequests() {
        return 16;
    }

    public int maxSequences() {
        return 16;
    }

    public Sequence sequence(String name) {
        Sequence sequence = this.sequenceMap.get(name);
        if (sequence == null) {
            throw new IllegalArgumentException("Unknown sequence '" + name + "'");
        }
        return sequence;
    }
}

