/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.SLABuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class SLA
implements Serializable {
    public static final SLA[] DEFAULT = new SLA[]{new SLABuilder<Object>(null).build()};
    private final long window;
    private final double errorRatio;
    private final long meanResponseTime;
    private final double blockedRatio;
    private final Collection<PercentileLimit> limits;

    public SLA(long window, double errorRatio, long meanResponseTime, double blockedRatio, Collection<PercentileLimit> limits) {
        this.window = window;
        this.meanResponseTime = meanResponseTime;
        this.errorRatio = errorRatio;
        this.blockedRatio = blockedRatio;
        this.limits = limits;
    }

    public long window() {
        return this.window;
    }

    public double errorRatio() {
        return this.errorRatio;
    }

    public long meanResponseTime() {
        return this.meanResponseTime;
    }

    public double blockedRatio() {
        return this.blockedRatio;
    }

    public Collection<PercentileLimit> percentileLimits() {
        return Collections.unmodifiableCollection(this.limits);
    }

    public Failure validate(String phase, String metric, StatisticsSnapshot statistics) {
        double actualBlockedRatio;
        double mean;
        double actualErrorRatio = (double)statistics.errors() / (double)statistics.requestCount;
        if (actualErrorRatio >= this.errorRatio) {
            return new Failure(this, phase, metric, statistics.clone(), String.format("Error ratio exceeded: required %.3f, actual %.3f", this.errorRatio, actualErrorRatio));
        }
        if (this.meanResponseTime < Long.MAX_VALUE && (mean = statistics.histogram.getMean()) >= (double)this.meanResponseTime) {
            return new Failure(this, phase, metric, statistics.clone(), String.format("Mean response time exceeded: required %d, actual %.3f", this.meanResponseTime, mean));
        }
        if (statistics.blockedTime > 0L && (actualBlockedRatio = (double)statistics.blockedTime / (statistics.histogram.getMean() * (double)statistics.histogram.getTotalCount())) > this.blockedRatio) {
            return new Failure(this, phase, metric, statistics.clone(), String.format("Progress was blocked waiting for a free connection. Hint: increase http.sharedConnections.", new Object[0]));
        }
        for (PercentileLimit limit : this.limits) {
            long value = statistics.histogram.getValueAtPercentile(limit.percentile());
            if (value < limit.responseTime()) continue;
            return new Failure(this, phase, metric, statistics.clone(), String.format("Response time at percentile %f exceeded: required %d, actual %d", limit.percentile, limit.responseTime, value));
        }
        return null;
    }

    public static interface Provider
    extends Step {
        public int id();

        public SLA[] sla();

        public Sequence sequence();
    }

    public static class Failure {
        private final SLA sla;
        private final String phase;
        private final String metric;
        private final StatisticsSnapshot statistics;
        private final String message;

        public Failure(SLA sla, String phase, String metric, StatisticsSnapshot statistics, String message) {
            this.sla = sla;
            this.phase = phase;
            this.metric = metric;
            this.statistics = statistics;
            this.message = message;
        }

        public SLA sla() {
            return this.sla;
        }

        public String phase() {
            return this.phase;
        }

        public String metric() {
            return this.metric;
        }

        public StatisticsSnapshot statistics() {
            return this.statistics;
        }

        public String message() {
            return this.message;
        }
    }

    public static class PercentileLimit
    implements Serializable {
        private final double percentile;
        private final long responseTime;

        public PercentileLimit(double percentile, long responseTime) {
            this.percentile = percentile;
            this.responseTime = responseTime;
        }

        public double percentile() {
            return this.percentile;
        }

        public long responseTime() {
            return this.responseTime;
        }
    }
}

