/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseForkBuilder;
import io.hyperfoil.api.config.PhaseReference;
import io.hyperfoil.api.config.RelativeIteration;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.function.SerializableSupplier;
import io.hyperfoil.impl.FutureSupplier;
import io.hyperfoil.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class PhaseBuilder<PB extends PhaseBuilder> {
    protected final String name;
    protected final BenchmarkBuilder parent;
    protected long startTime = -1L;
    protected Collection<PhaseReference> startAfter = new ArrayList<PhaseReference>();
    protected Collection<PhaseReference> startAfterStrict = new ArrayList<PhaseReference>();
    protected Collection<PhaseReference> terminateAfterStrict = new ArrayList<PhaseReference>();
    protected long duration = -1L;
    protected long maxDuration = -1L;
    protected int maxUnfinishedSessions = Integer.MAX_VALUE;
    protected int maxIterations = 1;
    protected List<PhaseForkBuilder> forks = new ArrayList<PhaseForkBuilder>();

    protected PhaseBuilder(BenchmarkBuilder parent, String name) {
        this.name = name;
        this.parent = parent;
        parent.addPhase(name, this);
    }

    public static Phase.Noop noop(SerializableSupplier<Benchmark> benchmark, int id, String iterationName, List<String> startAfter, List<String> startAfterStrict, List<String> terminateAfterStrict) {
        FutureSupplier<Phase.Noop> ps = new FutureSupplier<Phase.Noop>();
        Scenario scenario = new Scenario(new Sequence[0], new Sequence[0], new String[0], new String[0]);
        Phase.Noop phase = new Phase.Noop(benchmark, id, iterationName, startAfter, startAfterStrict, terminateAfterStrict, scenario);
        ps.set(phase);
        return phase;
    }

    public BenchmarkBuilder endPhase() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public ScenarioBuilder scenario() {
        if (this.forks.isEmpty()) {
            PhaseForkBuilder fork = new PhaseForkBuilder(this, null);
            this.forks.add(fork);
            return fork.scenario;
        }
        if (this.forks.size() == 1 && this.forks.get((int)0).name == null) {
            throw new BenchmarkDefinitionException("Scenario for " + this.name + " already set!");
        }
        throw new BenchmarkDefinitionException("Scenario is forked; you need to specify another fork.");
    }

    private PB self() {
        return (PB)this;
    }

    public PhaseForkBuilder fork(String name) {
        if (this.forks.size() == 1 && this.forks.get((int)0).name == null) {
            throw new BenchmarkDefinitionException("Scenario for " + name + " already set!");
        }
        PhaseForkBuilder fork = new PhaseForkBuilder(this, name);
        this.forks.add(fork);
        return fork;
    }

    public PB startTime(long startTime) {
        this.startTime = startTime;
        return this.self();
    }

    public PB startTime(String startTime) {
        return this.startTime(Util.parseToMillis(startTime));
    }

    public PB startAfter(String phase) {
        this.startAfter.add(new PhaseReference(phase, RelativeIteration.NONE, null));
        return this.self();
    }

    public PB startAfter(PhaseReference phase) {
        this.startAfter.add(phase);
        return this.self();
    }

    public PB startAfterStrict(String phase) {
        this.startAfterStrict.add(new PhaseReference(phase, RelativeIteration.NONE, null));
        return this.self();
    }

    public PB startAfterStrict(PhaseReference phase) {
        this.startAfterStrict.add(phase);
        return this.self();
    }

    public PB duration(long duration) {
        this.duration = duration;
        return this.self();
    }

    public PB duration(String duration) {
        return this.duration(Util.parseToMillis(duration));
    }

    public PB maxDuration(long maxDuration) {
        this.maxDuration = maxDuration;
        return this.self();
    }

    public PB maxDuration(String duration) {
        return this.maxDuration(Util.parseToMillis(duration));
    }

    public PB maxUnfinishedSessions(int maxUnfinishedSessions) {
        this.maxUnfinishedSessions = maxUnfinishedSessions;
        return this.self();
    }

    public PB maxIterations(int iterations) {
        this.maxIterations = iterations;
        return this.self();
    }

    public void prepareBuild() {
        this.forks.forEach(fork -> fork.scenario.prepareBuild());
    }

    public Collection<Phase> build(SerializableSupplier<Benchmark> benchmark, AtomicInteger idCounter) {
        if (this.forks.isEmpty()) {
            throw new BenchmarkDefinitionException("Scenario for " + this.name + " is not defined.");
        }
        if (this.forks.size() == 1 && this.forks.get((int)0).name != null) {
            throw new BenchmarkDefinitionException(this.name + " has single fork: define scenario directly.");
        }
        boolean hasForks = this.forks.size() > 1;
        this.forks.removeIf(fork -> fork.weight <= 0.0);
        double sumWeight = this.forks.stream().mapToDouble(f -> f.weight).sum();
        this.forks.forEach(f -> f.weight /= sumWeight);
        List<Phase> phases = IntStream.range(0, this.maxIterations).mapToObj(iteration -> this.forks.stream().map(f -> {
            FutureSupplier<Phase> ps = new FutureSupplier<Phase>();
            Phase phase = this.buildPhase(benchmark, (SerializableSupplier<Phase>)ps, idCounter.getAndIncrement(), iteration, (PhaseForkBuilder)f);
            ps.set(phase);
            return phase;
        })).flatMap(Function.identity()).collect(Collectors.toList());
        if (this.maxIterations > 1) {
            if (hasForks) {
                IntStream.range(0, this.maxIterations).mapToObj(iteration -> {
                    String iterationName = this.formatIteration(this.name, iteration);
                    List<String> forks = this.forks.stream().map(f -> iterationName + "/" + f.name).collect(Collectors.toList());
                    return PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), iterationName, forks, Collections.emptyList(), forks);
                }).forEach(phases::add);
            }
            List<String> lastIteration = Collections.singletonList(this.formatIteration(this.name, this.maxIterations - 1));
            phases.add(PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), this.name, lastIteration, Collections.emptyList(), lastIteration));
        } else if (hasForks) {
            List<String> forks = this.forks.stream().map(f -> this.name + "/" + f.name).collect(Collectors.toList());
            phases.add(PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), this.name, forks, Collections.emptyList(), forks));
        }
        return phases;
    }

    protected abstract Phase buildPhase(SerializableSupplier<Benchmark> var1, SerializableSupplier<Phase> var2, int var3, int var4, PhaseForkBuilder var5);

    int sliceValue(String property, int value, double ratio) {
        double sliced = (double)value * ratio;
        long rounded = Math.round(sliced);
        if (Math.abs((double)rounded - sliced) > 1.0E-4) {
            throw new BenchmarkDefinitionException("Cannot slice phase " + this.name + ", property " + property + " cleanly: " + value + " * " + ratio + " is not an integer.");
        }
        return (int)rounded;
    }

    int numAgents() {
        return Math.max(this.parent.numAgents(), 1);
    }

    String iterationName(int iteration, String forkName) {
        if (this.maxIterations == 1) {
            assert (iteration == 0);
            if (forkName == null) {
                return this.name;
            }
            return this.name + "/" + forkName;
        }
        String iterationName = this.formatIteration(this.name, iteration);
        if (forkName == null) {
            return iterationName;
        }
        return iterationName + "/" + forkName;
    }

    private String formatIteration(String name, int iteration) {
        return String.format("%s/%03d", name, iteration);
    }

    long iterationStartTime(int iteration) {
        return iteration == 0 ? this.startTime : -1L;
    }

    String sharedResources(PhaseForkBuilder fork) {
        if (fork == null || fork.name == null) {
            return this.name;
        }
        return this.name + "/" + fork;
    }

    Collection<String> iterationReferences(Collection<PhaseReference> refs, int iteration, boolean addSelfPrevious) {
        ArrayList<String> names = new ArrayList<String>();
        block5: for (PhaseReference ref : refs) {
            switch (ref.iteration) {
                case NONE: {
                    names.add(ref.phase);
                    continue block5;
                }
                case PREVIOUS: {
                    if (this.maxIterations <= 1) {
                        throw new BenchmarkDefinitionException(this.name + " referencing previous iteration of " + ref.phase + " but this phase has no iterations.");
                    }
                    if (iteration <= 0) continue block5;
                    names.add(this.formatIteration(ref.phase, iteration - 1));
                    continue block5;
                }
                case SAME: {
                    if (this.maxIterations <= 1) {
                        throw new BenchmarkDefinitionException(this.name + " referencing previous iteration of " + ref.phase + " but this phase has no iterations.");
                    }
                    names.add(this.formatIteration(ref.phase, iteration));
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
        if (addSelfPrevious && iteration > 0) {
            names.add(this.formatIteration(this.name, iteration - 1));
        }
        return names;
    }

    public void readForksFrom(PhaseBuilder<?> other) {
        for (PhaseForkBuilder builder : other.forks) {
            this.fork(builder.name).readFrom(builder);
        }
    }

    public static class Catalog {
        private final BenchmarkBuilder parent;
        private final String name;

        Catalog(BenchmarkBuilder parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public AtOnce atOnce(int users) {
            return new AtOnce(this.parent, this.name, users);
        }

        public Always always(int users) {
            return new Always(this.parent, this.name, users);
        }

        public RampPerSec rampPerSec(int initialUsersPerSec, int targetUsersPerSec) {
            return new RampPerSec(this.parent, this.name, initialUsersPerSec, targetUsersPerSec);
        }

        public ConstantPerSec constantPerSec(int usersPerSec) {
            return new ConstantPerSec(this.parent, this.name, usersPerSec);
        }

        public Sequentially sequentially(int repeats) {
            return new Sequentially(this.parent, this.name, repeats);
        }
    }

    public static class Sequentially
    extends PhaseBuilder<Sequentially> {
        private int repeats;

        protected Sequentially(BenchmarkBuilder parent, String name, int repeats) {
            super(parent, name);
            this.repeats = repeats;
        }

        @Override
        protected Phase buildPhase(SerializableSupplier<Benchmark> benchmark, SerializableSupplier<Phase> phase, int id, int i, PhaseForkBuilder f) {
            return new Phase.Sequentially(benchmark, id, this.iterationName(i, f.name), f.scenario().build(phase), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, (int)Math.ceil((double)this.maxUnfinishedSessions * f.weight / (double)this.numAgents()), this.sharedResources(f), this.repeats);
        }
    }

    public static class ConstantPerSec
    extends PhaseBuilder<ConstantPerSec> {
        private double usersPerSec;
        private double usersPerSecIncrement;
        private int maxSessionsEstimate;
        private boolean variance = true;

        ConstantPerSec(BenchmarkBuilder parent, String name, double usersPerSec) {
            super(parent, name);
            this.usersPerSec = usersPerSec;
        }

        public ConstantPerSec maxSessionsEstimate(int maxSessionsEstimate) {
            this.maxSessionsEstimate = maxSessionsEstimate;
            return this;
        }

        @Override
        public Phase.ConstantPerSec buildPhase(SerializableSupplier<Benchmark> benchmark, SerializableSupplier<Phase> phase, int id, int i, PhaseForkBuilder f) {
            int maxSessionsEstimate = this.maxSessionsEstimate <= 0 ? (int)Math.ceil(f.weight / (double)this.numAgents() * (this.usersPerSec + this.usersPerSecIncrement * (double)(this.maxIterations - 1))) : this.sliceValue("maxSessionsEstimate", this.maxSessionsEstimate, f.weight / (double)this.numAgents());
            return new Phase.ConstantPerSec(benchmark, id, this.iterationName(i, f.name), f.scenario.build(phase), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, (int)Math.ceil((double)this.maxUnfinishedSessions * f.weight / (double)this.numAgents()), this.sharedResources(f), (this.usersPerSec + this.usersPerSecIncrement * (double)i) * f.weight / (double)this.numAgents(), this.variance, maxSessionsEstimate);
        }

        public ConstantPerSec usersPerSec(double usersPerSec) {
            this.usersPerSec = usersPerSec;
            return this;
        }

        public ConstantPerSec usersPerSec(double base, double increment) {
            this.usersPerSec = base;
            this.usersPerSecIncrement = increment;
            return this;
        }

        public ConstantPerSec variance(boolean variance) {
            this.variance = variance;
            return this;
        }
    }

    public static class RampPerSec
    extends PhaseBuilder<RampPerSec> {
        private double initialUsersPerSec;
        private double initialUsersPerSecIncrement;
        private double targetUsersPerSec;
        private double targetUsersPerSecIncrement;
        private int maxSessionsEstimate;
        private boolean variance = true;

        RampPerSec(BenchmarkBuilder parent, String name, double initialUsersPerSec, double targetUsersPerSec) {
            super(parent, name);
            this.initialUsersPerSec = initialUsersPerSec;
            this.targetUsersPerSec = targetUsersPerSec;
        }

        public RampPerSec maxSessionsEstimate(int maxSessionsEstimate) {
            this.maxSessionsEstimate = maxSessionsEstimate;
            return this;
        }

        @Override
        public Phase.RampPerSec buildPhase(SerializableSupplier<Benchmark> benchmark, SerializableSupplier<Phase> phase, int id, int i, PhaseForkBuilder f) {
            int maxSessionsEstimate;
            if (this.maxSessionsEstimate > 0) {
                maxSessionsEstimate = this.sliceValue("maxSessionsEstimate", this.maxSessionsEstimate, f.weight / (double)this.numAgents());
            } else {
                double maxInitialUsers = this.initialUsersPerSec + this.initialUsersPerSecIncrement * (double)(this.maxIterations - 1);
                double maxTargetUsers = this.targetUsersPerSec + this.targetUsersPerSecIncrement * (double)(this.maxIterations - 1);
                maxSessionsEstimate = (int)Math.ceil(Math.max(maxInitialUsers, maxTargetUsers) * f.weight / (double)this.numAgents());
            }
            return new Phase.RampPerSec(benchmark, id, this.iterationName(i, f.name), f.scenario.build(phase), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, (int)Math.ceil((double)this.maxUnfinishedSessions * f.weight / (double)this.numAgents()), this.sharedResources(f), (this.initialUsersPerSec + this.initialUsersPerSecIncrement * (double)i) * f.weight / (double)this.numAgents(), (this.targetUsersPerSec + this.targetUsersPerSecIncrement * (double)i) * f.weight / (double)this.numAgents(), this.variance, maxSessionsEstimate);
        }

        public RampPerSec initialUsersPerSec(double initialUsersPerSec) {
            this.initialUsersPerSec = initialUsersPerSec;
            this.initialUsersPerSecIncrement = 0.0;
            return this;
        }

        public RampPerSec initialUsersPerSec(double base, double increment) {
            this.initialUsersPerSec = base;
            this.initialUsersPerSecIncrement = increment;
            return this;
        }

        public RampPerSec targetUsersPerSec(double targetUsersPerSec) {
            this.targetUsersPerSec = targetUsersPerSec;
            this.targetUsersPerSecIncrement = 0.0;
            return this;
        }

        public RampPerSec targetUsersPerSec(double base, double increment) {
            this.targetUsersPerSec = base;
            this.targetUsersPerSecIncrement = increment;
            return this;
        }

        public RampPerSec variance(boolean variance) {
            this.variance = variance;
            return this;
        }
    }

    public static class Always
    extends PhaseBuilder<Always> {
        private int users;
        private int usersIncrement;

        Always(BenchmarkBuilder parent, String name, int users) {
            super(parent, name);
            this.users = users;
        }

        @Override
        public Phase.Always buildPhase(SerializableSupplier<Benchmark> benchmark, SerializableSupplier<Phase> phase, int id, int i, PhaseForkBuilder f) {
            return new Phase.Always(benchmark, id, this.iterationName(i, f.name), f.scenario.build(phase), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, (int)Math.ceil((double)this.maxUnfinishedSessions * f.weight / (double)this.numAgents()), this.sharedResources(f), this.sliceValue("users", this.users + this.usersIncrement * i, f.weight / (double)this.numAgents()));
        }

        public Always users(int users) {
            this.users = users;
            return this;
        }

        public Always users(int base, int increment) {
            this.users = base;
            this.usersIncrement = increment;
            return this;
        }
    }

    public static class AtOnce
    extends PhaseBuilder<AtOnce> {
        private int users;
        private int usersIncrement;

        AtOnce(BenchmarkBuilder parent, String name, int users) {
            super(parent, name);
            this.users = users;
        }

        public AtOnce users(int users) {
            this.users = users;
            return this;
        }

        public AtOnce users(int base, int increment) {
            this.users = base;
            this.usersIncrement = increment;
            return this;
        }

        @Override
        public Phase.AtOnce buildPhase(SerializableSupplier<Benchmark> benchmark, SerializableSupplier<Phase> phase, int id, int i, PhaseForkBuilder f) {
            return new Phase.AtOnce(benchmark, id, this.iterationName(i, f.name), f.scenario.build(phase), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, (int)Math.ceil((double)this.maxUnfinishedSessions * f.weight / (double)this.numAgents()), this.sharedResources(f), this.sliceValue("users", this.users + this.usersIncrement * i, f.weight / (double)this.numAgents()));
        }
    }
}

