/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.function.SerializableSupplier;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Collection;

public abstract class Phase
implements Serializable {
    protected static final Logger log = LoggerFactory.getLogger(Phase.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected final SerializableSupplier<Benchmark> benchmark;
    public final int id;
    public final String name;
    public final Scenario scenario;
    public final long startTime;
    public final Collection<String> startAfter;
    public final Collection<String> startAfterStrict;
    public final Collection<String> terminateAfterStrict;
    public final long duration;
    public final long maxDuration;
    public final int maxUnfinishedSessions;
    public final String sharedResources;

    public Phase(SerializableSupplier<Benchmark> benchmark, int id, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, int maxUnfinishedSessions, String sharedResources) {
        this.benchmark = benchmark;
        this.id = id;
        this.name = name;
        this.terminateAfterStrict = terminateAfterStrict;
        this.maxDuration = maxDuration;
        this.startAfter = startAfter;
        this.startAfterStrict = startAfterStrict;
        this.scenario = scenario;
        this.startTime = startTime;
        this.duration = duration;
        this.maxUnfinishedSessions = maxUnfinishedSessions;
        this.sharedResources = sharedResources;
        if (duration < 0L) {
            throw new BenchmarkDefinitionException("Duration was not set for phase '" + name + "'");
        }
        if (scenario == null) {
            throw new BenchmarkDefinitionException("Scenario was not set for phase '" + name + "'");
        }
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Scenario scenario() {
        return this.scenario;
    }

    public long startTime() {
        return this.startTime;
    }

    public Collection<String> startAfter() {
        return this.startAfter;
    }

    public Collection<String> startAfterStrict() {
        return this.startAfterStrict;
    }

    public Collection<String> terminateAfterStrict() {
        return this.terminateAfterStrict;
    }

    public long duration() {
        return this.duration;
    }

    public long maxDuration() {
        return this.maxDuration;
    }

    public Benchmark benchmark() {
        return (Benchmark)this.benchmark.get();
    }

    private static int requirePositive(int value, String message) {
        if (value <= 0) {
            throw new BenchmarkDefinitionException(message);
        }
        return value;
    }

    private static double requireNonNegative(double value, String message) {
        if (value < 0.0) {
            throw new BenchmarkDefinitionException(message);
        }
        return value;
    }

    public abstract String description();

    public static class Noop
    extends Phase {
        public Noop(SerializableSupplier<Benchmark> benchmark, int id, String name, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, Scenario scenario) {
            super(benchmark, id, name, scenario, -1L, startAfter, startAfterStrict, terminateAfterStrict, 0L, -1L, 0, null);
        }

        @Override
        public String description() {
            return "";
        }
    }

    public static class Sequentially
    extends Phase {
        public final int repeats;

        public Sequentially(SerializableSupplier<Benchmark> benchmark, int id, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, int maxUnfinishedSessions, String sharedResources, int repeats) {
            super(benchmark, id, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, maxUnfinishedSessions, sharedResources);
            this.repeats = Phase.requirePositive(repeats, "Phase " + name + " requires positive number of repeats!");
        }

        @Override
        public String description() {
            return this.repeats + " times";
        }
    }

    public static class ConstantPerSec
    extends Phase {
        public final double usersPerSec;
        public final int maxSessionsEstimate;
        public final boolean variance;

        public ConstantPerSec(SerializableSupplier<Benchmark> benchmark, int id, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, int maxUnfinishedSessions, String sharedResources, double usersPerSec, boolean variance, int maxSessionsEstimate) {
            super(benchmark, id, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, maxUnfinishedSessions, sharedResources);
            this.usersPerSec = Phase.requireNonNegative(usersPerSec, "Phase " + name + " requires non-negative number of users per second!");
            this.variance = variance;
            this.maxSessionsEstimate = maxSessionsEstimate;
        }

        @Override
        public String description() {
            return String.format("%.2f users per second", this.usersPerSec * (double)((Benchmark)this.benchmark.get()).agents().length);
        }
    }

    public static class RampPerSec
    extends Phase {
        public final double initialUsersPerSec;
        public final double targetUsersPerSec;
        public final int maxSessionsEstimate;
        public final boolean variance;

        public RampPerSec(SerializableSupplier<Benchmark> benchmark, int id, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, int maxUnfinishedSessions, String sharedResources, double initialUsersPerSec, double targetUsersPerSec, boolean variance, int maxSessionsEstimate) {
            super(benchmark, id, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, maxUnfinishedSessions, sharedResources);
            this.initialUsersPerSec = Phase.requireNonNegative(initialUsersPerSec, "Phase " + name + " requires non-negative number of initial users per second!");
            this.targetUsersPerSec = Phase.requireNonNegative(targetUsersPerSec, "Phase " + name + " requires non-negative number of target users per second!");
            this.variance = variance;
            this.maxSessionsEstimate = maxSessionsEstimate;
        }

        @Override
        public String description() {
            int numAgents = ((Benchmark)this.benchmark.get()).agents().length;
            return String.format("%.2f - %.2f users per second", this.initialUsersPerSec * (double)numAgents, this.targetUsersPerSec * (double)numAgents);
        }
    }

    public static class Always
    extends Phase {
        public final int users;

        public Always(SerializableSupplier<Benchmark> benchmark, int id, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, int maxUnfinishedSessions, String sharedResources, int users) {
            super(benchmark, id, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, maxUnfinishedSessions, sharedResources);
            this.users = Phase.requirePositive(users, "Phase " + name + " requires positive number of users!");
        }

        @Override
        public String description() {
            return this.users * ((Benchmark)this.benchmark.get()).agents().length + " users always";
        }
    }

    public static class AtOnce
    extends Phase {
        public final int users;

        public AtOnce(SerializableSupplier<Benchmark> benchmark, int id, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, int maxUnfinishedSessions, String sharedResources, int users) {
            super(benchmark, id, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, 0L, maxDuration, maxUnfinishedSessions, sharedResources);
            if (duration > 0L) {
                log.warn((Object)"Duration for phase {} is ignored.", new Object[]{duration});
            }
            this.users = Phase.requirePositive(users, "Phase " + name + " requires positive number of users!");
        }

        @Override
        public String description() {
            return this.users * ((Benchmark)this.benchmark.get()).agents().length + " users at once";
        }
    }
}

