/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.StepBuilder;

public interface Locator {
    public StepBuilder step();

    public BaseSequenceBuilder sequence();

    public ScenarioBuilder scenario();

    public static Locator fromStep(StepBuilder step) {
        if (!step.canBeLocated()) {
            throw new IllegalStateException(step + " cannot be located as it does not support deep copy.");
        }
        return new Step(step);
    }

    public static class Step
    implements Locator {
        private final StepBuilder step;

        private Step(StepBuilder step) {
            this.step = step;
        }

        @Override
        public StepBuilder step() {
            return this.step;
        }

        @Override
        public BaseSequenceBuilder sequence() {
            return this.step.endStep();
        }

        @Override
        public ScenarioBuilder scenario() {
            return this.step.endStep().endSequence();
        }
    }
}

