/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Locator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface BuilderBase<S extends BuilderBase<S>> {
    default public void prepareBuild() {
    }

    default public S copy(Locator locator) {
        return (S)this;
    }

    public static <T extends BuilderBase<T>> List<T> copy(Locator locator, Collection<? extends BuilderBase<T>> builders) {
        return builders.stream().map(b -> b.copy(locator)).collect(Collectors.toList());
    }
}

