/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ErgonomicsBuilder;
import io.hyperfoil.api.config.Http;
import io.hyperfoil.api.config.HttpBuilder;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.impl.FutureSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class BenchmarkBuilder {
    private final String originalSource;
    private final BenchmarkData data;
    private String name;
    private Collection<Agent> agents = new ArrayList<Agent>();
    private ErgonomicsBuilder ergonomics = new ErgonomicsBuilder();
    private HttpBuilder defaultHttp;
    private List<HttpBuilder> httpList = new ArrayList<HttpBuilder>();
    private int threads = 1;
    private Map<String, PhaseBuilder<?>> phaseBuilders = new HashMap();
    private long statisticsCollectionPeriod = 1000L;

    public BenchmarkBuilder(String originalSource, BenchmarkData data) {
        this.originalSource = originalSource;
        this.data = data;
    }

    public static BenchmarkBuilder builder() {
        return new BenchmarkBuilder(null, BenchmarkData.EMPTY);
    }

    public BenchmarkBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BenchmarkBuilder addAgent(String name, String inlineConfig, Map<String, String> properties) {
        Agent agent = new Agent(name, inlineConfig, properties);
        if (this.agents.stream().anyMatch(a -> a.name.equals(agent.name))) {
            throw new BenchmarkDefinitionException("Benchmark already contains agent '" + agent.name + "'");
        }
        this.agents.add(agent);
        return this;
    }

    int numAgents() {
        return this.agents.size();
    }

    public ErgonomicsBuilder ergonomics() {
        return this.ergonomics;
    }

    public HttpBuilder http() {
        if (this.defaultHttp == null) {
            this.defaultHttp = new HttpBuilder(this);
        }
        return this.defaultHttp;
    }

    public HttpBuilder http(String host) {
        HttpBuilder builder = new HttpBuilder(this).host(host);
        this.httpList.add(builder);
        return builder;
    }

    public BenchmarkBuilder threads(int threads) {
        this.threads = threads;
        return this;
    }

    public PhaseBuilder.Catalog addPhase(String name) {
        return new PhaseBuilder.Catalog(this, name);
    }

    public PhaseBuilder.ConstantPerSec singleConstantPerSecPhase() {
        if (this.phaseBuilders.isEmpty()) {
            return new PhaseBuilder.Catalog(this, "main").constantPerSec(0);
        }
        PhaseBuilder<?> builder = this.phaseBuilders.get("main");
        if (!(builder instanceof PhaseBuilder.ConstantPerSec)) {
            throw new BenchmarkDefinitionException("Benchmark already has defined phases; cannot use single-phase definition");
        }
        return (PhaseBuilder.ConstantPerSec)builder;
    }

    public void prepareBuild() {
        if (this.defaultHttp == null) {
            if (this.httpList.isEmpty()) {
                throw new BenchmarkDefinitionException("No default HTTP target set!");
            }
            if (this.httpList.size() == 1) {
                this.defaultHttp = this.httpList.iterator().next();
            }
        } else {
            if (this.httpList.stream().anyMatch(http -> http.authority().equals(this.defaultHttp.authority()))) {
                throw new BenchmarkDefinitionException("Ambiguous HTTP definition for " + this.defaultHttp.authority() + ": defined both as default and non-default");
            }
            this.httpList.add(this.defaultHttp);
        }
        HashSet<String> authorities = new HashSet<String>();
        for (HttpBuilder http2 : this.httpList) {
            if (authorities.add(http2.authority())) continue;
            throw new BenchmarkDefinitionException("Duplicit HTTP definition for " + http2.authority());
        }
        this.httpList.forEach(HttpBuilder::prepareBuild);
        this.phaseBuilders.values().forEach(PhaseBuilder::prepareBuild);
    }

    public Benchmark build() {
        this.prepareBuild();
        FutureSupplier<Benchmark> bs = new FutureSupplier<Benchmark>();
        Map<String, Http> httpMap = this.httpList.stream().collect(Collectors.toMap(HttpBuilder::authority, http -> http.build(http == this.defaultHttp)));
        AtomicInteger phaseIdCounter = new AtomicInteger(0);
        Collection phases = this.phaseBuilders.values().stream().flatMap(builder -> builder.build(bs, phaseIdCounter).stream()).collect(Collectors.toList());
        Set<String> phaseNames = phases.stream().map(Phase::name).collect(Collectors.toSet());
        for (Phase phase : phases) {
            this.checkDependencies(phase, phase.startAfter, phaseNames);
            this.checkDependencies(phase, phase.startAfterStrict, phaseNames);
            this.checkDependencies(phase, phase.terminateAfterStrict, phaseNames);
        }
        HashMap<String, Object> tags = new HashMap<String, Object>();
        if (this.defaultHttp != null) {
            Http defaultHttp = this.defaultHttp.build(true);
            tags.put("url", defaultHttp.protocol().scheme + "://" + defaultHttp.host() + ":" + defaultHttp.port());
            tags.put("protocol", defaultHttp.protocol().scheme);
        }
        tags.put("threads", this.threads);
        Map<String, byte[]> files = this.data.files();
        Benchmark benchmark = new Benchmark(this.name, this.originalSource, files, this.agents.toArray(new Agent[0]), this.threads, this.ergonomics.build(), httpMap, phases, tags, this.statisticsCollectionPeriod);
        bs.set(benchmark);
        return benchmark;
    }

    private void checkDependencies(Phase phase, Collection<String> references, Set<String> phaseNames) {
        for (String dep : references) {
            if (phaseNames.contains(dep)) continue;
            String suggestion = phaseNames.stream().filter(name -> name.toLowerCase().startsWith(dep)).findAny().map(name -> " Did you mean " + name + "?").orElse("");
            throw new BenchmarkDefinitionException("Phase " + dep + " referenced from " + phase.name() + " is not defined." + suggestion);
        }
    }

    void addPhase(String name, PhaseBuilder phaseBuilder) {
        if (this.phaseBuilders.containsKey(name)) {
            throw new IllegalArgumentException("Phase '" + name + "' already defined.");
        }
        this.phaseBuilders.put(name, phaseBuilder);
    }

    public BenchmarkBuilder statisticsCollectionPeriod(long statisticsCollectionPeriod) {
        this.statisticsCollectionPeriod = statisticsCollectionPeriod;
        return this;
    }

    Collection<PhaseBuilder<?>> phases() {
        return this.phaseBuilders.values();
    }

    public boolean validateAuthority(String authority) {
        return authority == null && this.defaultHttp != null || this.httpList.stream().anyMatch(http -> http.authority().equals(authority));
    }

    public HttpBuilder decoupledHttp() {
        return new HttpBuilder(this);
    }

    public void addHttp(HttpBuilder builder) {
        if (builder.authority() == null) {
            throw new BenchmarkDefinitionException("Missing hostname!");
        }
        this.httpList.add(builder);
    }

    public BenchmarkData data() {
        return this.data;
    }
}

