/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Ergonomics;
import io.hyperfoil.api.config.Http;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Step;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public class Benchmark
implements Serializable {
    private final String name;
    private final String originalSource;
    private final Map<String, byte[]> files;
    private final Agent[] agents;
    private final int threads;
    private final Ergonomics ergonomics;
    private final Map<String, Http> http;
    private final Http defaultHttp;
    private final Collection<Phase> phases;
    private final Map<String, Object> tags;
    private final long statisticsCollectionPeriod;

    public Benchmark(String name, String originalSource, Map<String, byte[]> files, Agent[] agents, int threads, Ergonomics ergonomics, Map<String, Http> http, Collection<Phase> phases, Map<String, Object> tags, long statisticsCollectionPeriod) {
        this.name = name;
        this.originalSource = originalSource;
        this.files = files;
        this.agents = agents;
        this.threads = threads;
        this.ergonomics = ergonomics;
        this.http = http;
        this.defaultHttp = http.values().stream().filter(Http::isDefault).findFirst().orElse(null);
        this.phases = phases;
        this.tags = tags;
        this.statisticsCollectionPeriod = statisticsCollectionPeriod;
    }

    public String name() {
        return this.name;
    }

    public Agent[] agents() {
        return this.agents;
    }

    public String source() {
        return this.originalSource;
    }

    public Map<String, byte[]> files() {
        return this.files;
    }

    public int threads() {
        return this.threads;
    }

    public Collection<Phase> phases() {
        return this.phases;
    }

    public Map<String, Object> tags() {
        return this.tags;
    }

    public Map<String, Http> http() {
        return this.http;
    }

    public Http defaultHttp() {
        return this.defaultHttp;
    }

    public long statisticsCollectionPeriod() {
        return this.statisticsCollectionPeriod;
    }

    public String toString() {
        return "Benchmark{name='" + this.name + '\'' + ", originalSource='" + this.originalSource + '\'' + ", agents=" + Arrays.toString(this.agents) + ", threads=" + this.threads + ", http=" + this.http + ", phases=" + this.phases + ", tags=" + this.tags + ", statisticsCollectionPeriod=" + this.statisticsCollectionPeriod + '}';
    }

    public Stream<Step> steps() {
        return this.phases().stream().flatMap(phase -> Stream.of(phase.scenario().sequences())).flatMap(sequence -> Stream.of(sequence.steps()));
    }

    public Phase[] phasesById() {
        Phase[] phases = new Phase[this.phases.size()];
        this.phases.forEach(p -> {
            phases[p.id()] = p;
        });
        return phases;
    }
}

