/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.function.SerializableSupplier;
import io.hyperfoil.impl.StepCatalogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public abstract class BaseSequenceBuilder
implements Rewritable<BaseSequenceBuilder> {
    private static final StepCatalogFactory sdf;
    protected final BaseSequenceBuilder parent;
    protected final List<StepBuilder> steps = new ArrayList<StepBuilder>();

    public BaseSequenceBuilder(BaseSequenceBuilder parent) {
        this.parent = parent;
    }

    public <D extends Step.Catalog> D step(Class<D> catalogClass) {
        if (sdf == null) {
            throw new IllegalStateException("Cannot load step catalog");
        }
        Step.Catalog catalog = sdf.create(this);
        if (catalogClass.isInstance(catalog)) {
            return (D)((Step.Catalog)catalogClass.cast(catalog));
        }
        throw new IllegalStateException("Unknown step catalog " + catalog + ", want: " + catalogClass);
    }

    public BaseSequenceBuilder step(Step step) {
        this.steps.add(new ProvidedStepBuilder(step, this));
        return this;
    }

    public BaseSequenceBuilder stepBuilder(StepBuilder stepBuilder) {
        this.steps.add(stepBuilder);
        return this;
    }

    public SequenceBuilder end() {
        return this.parent.end();
    }

    public ScenarioBuilder endSequence() {
        return this.end().endSequence();
    }

    @Override
    public void readFrom(BaseSequenceBuilder other) {
        assert (this.steps.isEmpty());
        other.steps.forEach(s -> s.addCopyTo(this));
    }

    public String name() {
        return this.parent.name();
    }

    public BaseSequenceBuilder insertBefore(StepBuilder step) {
        return this.insertWithOffset(step, 0);
    }

    public BaseSequenceBuilder insertAfter(StepBuilder step) {
        return this.insertWithOffset(step, 1);
    }

    private BaseSequenceBuilder insertWithOffset(StepBuilder step, int offset) {
        if (!step.canBeLocated()) {
            throw new IllegalStateException(step + " cannot be located as it does not support deep copy.");
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            if (this.steps.get(i) != step) continue;
            StepInserter inserter = new StepInserter(this);
            this.steps.add(i + offset, inserter);
            return inserter;
        }
        throw new NoSuchElementException("Not found: " + step);
    }

    protected List<Step> buildSteps(SerializableSupplier<Sequence> sequence) {
        return this.steps.stream().map(b -> b.build(sequence)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        StepCatalogFactory singleSdf = null;
        Iterator<StepCatalogFactory> iterator = ServiceLoader.load(StepCatalogFactory.class).iterator();
        while (iterator.hasNext()) {
            StepCatalogFactory sdf;
            singleSdf = sdf = iterator.next();
        }
        sdf = singleSdf;
    }

    private static class ProvidedStepBuilder
    implements StepBuilder {
        private final Step step;
        private final BaseSequenceBuilder parent;

        public ProvidedStepBuilder(Step step, BaseSequenceBuilder parent) {
            this.step = step;
            this.parent = parent;
        }

        @Override
        public List<Step> build(SerializableSupplier<Sequence> sequence) {
            return Collections.singletonList(this.step);
        }

        @Override
        public BaseSequenceBuilder endStep() {
            return this.parent;
        }

        @Override
        public void addCopyTo(BaseSequenceBuilder newParent) {
            newParent.stepBuilder(new ProvidedStepBuilder(this.step, newParent));
        }

        @Override
        public boolean canBeLocated() {
            return true;
        }
    }

    private static class StepInserter
    extends BaseSequenceBuilder
    implements StepBuilder {
        private StepInserter(BaseSequenceBuilder parent) {
            super(parent);
        }

        @Override
        public List<Step> build(SerializableSupplier<Sequence> sequence) {
            return this.buildSteps(sequence);
        }

        @Override
        public BaseSequenceBuilder endStep() {
            return this.parent;
        }

        @Override
        public void addCopyTo(BaseSequenceBuilder newParent) {
            newParent.stepBuilder(new StepInserter(newParent));
        }

        @Override
        public boolean canBeLocated() {
            return true;
        }
    }
}

