/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.collection;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.function.Supplier;

public class LimitedPool<T> {
    private static final Logger log = LoggerFactory.getLogger(LimitedPool.class);
    private Object[] elements;
    private int mask;
    private int index;

    public LimitedPool(int capacity, Supplier<T> init) {
        this.mask = (1 << 32 - Integer.numberOfLeadingZeros(capacity - 1)) - 1;
        this.elements = new Object[this.mask + 1];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = init.get();
        }
    }

    public LimitedPool(T[] array) {
        this.mask = (1 << 32 - Integer.numberOfLeadingZeros(array.length - 1)) - 1;
        this.elements = new Object[this.mask + 1];
        System.arraycopy(array, 0, this.elements, 0, array.length);
    }

    public T acquire() {
        int i;
        for (i = this.index + 1; i != this.index && this.elements[i & this.mask] == null; ++i) {
        }
        if (this.elements[i & this.mask] == null) {
            return null;
        }
        this.index = i;
        Object object = this.elements[i];
        this.elements[i] = null;
        return (T)object;
    }

    public void release(T object) {
        int i;
        int stop = this.index + this.mask & this.mask;
        for (i = this.index; i != stop && this.elements[i & this.mask] != null; ++i) {
        }
        if (this.elements[i] != null) {
            for (i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] != object) continue;
                log.error((Object)"{} already returned to pool!", new Object[]{object});
                return;
            }
            throw new IllegalStateException("Pool should not be full!");
        }
        this.index = i + this.mask & this.mask;
        this.elements[i] = object;
    }

    public boolean isFull() {
        for (Object o : this.elements) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public boolean isDepleted() {
        for (Object o : this.elements) {
            if (o == null) continue;
            return false;
        }
        return true;
    }
}

