/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.hyperfoil.api.statistics.StatsExtension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@JsonTypeName(value="counters")
public class Counters
implements StatsExtension {
    final Map<Object, Integer> indices;
    long[] counters;

    public Counters() {
        this(new HashMap<Object, Integer>(), new long[8]);
    }

    public Counters(Map<Object, Integer> indices, long[] counters) {
        this.indices = indices;
        this.counters = counters;
    }

    @Override
    public boolean isNull() {
        for (int i = 0; i < this.counters.length; ++i) {
            if (this.counters[i] <= 0L) continue;
            return false;
        }
        return true;
    }

    public void increment(Object name) {
        int index;
        int n = index = this.getIndex(name);
        this.counters[n] = this.counters[n] + 1L;
    }

    private int getIndex(Object header) {
        Integer currentIndex = this.indices.get(header);
        if (currentIndex == null) {
            int nextIndex = this.indices.size();
            if (nextIndex == this.counters.length) {
                this.counters = Arrays.copyOf(this.counters, this.counters.length * 2);
            }
            currentIndex = nextIndex;
            this.indices.put(header, currentIndex);
        }
        return currentIndex;
    }

    @Override
    public void add(StatsExtension other) {
        if (other instanceof Counters) {
            Counters o = (Counters)other;
            for (Object header : o.indices.keySet()) {
                int index;
                int n = index = this.getIndex(header);
                this.counters[n] = this.counters[n] + o.counters[o.indices.get(header)];
            }
        } else {
            throw new IllegalArgumentException(other.toString());
        }
    }

    @Override
    public void subtract(StatsExtension other) {
        if (other instanceof Counters) {
            Counters o = (Counters)other;
            for (Object header : o.indices.keySet()) {
                int index;
                int n = index = this.getIndex(header);
                this.counters[n] = this.counters[n] - o.counters[o.indices.get(header)];
            }
        } else {
            throw new IllegalArgumentException(other.toString());
        }
    }

    @Override
    public void reset() {
        Arrays.fill(this.counters, 0L);
    }

    @Override
    public StatsExtension clone() {
        return new Counters(new HashMap<Object, Integer>(this.indices), Arrays.copyOf(this.counters, this.counters.length));
    }

    @Override
    public String[] headers() {
        return (String[])this.indices.keySet().stream().map(Object::toString).toArray(String[]::new);
    }

    @Override
    public String byHeader(String header) {
        for (Map.Entry<Object, Integer> entry : this.indices.entrySet()) {
            if (!entry.getKey().toString().equals(header)) continue;
            return String.valueOf(this.counters[entry.getValue()]);
        }
        return "<unknown header: " + header + ">";
    }

    @JsonAnyGetter
    public Map<String, Long> serialize() {
        return this.indices.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> this.counters[(Integer)e.getValue()]));
    }

    @JsonAnySetter
    public void set(String key, long value) {
        int index = this.getIndex(key);
        this.counters[index] = value;
    }
}

