/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.processor;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.IncludeBuilders;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.function.Function;

public interface Processor
extends Serializable {
    public static Builder adapt(Action.Builder builder) {
        return new ActionBuilderAdapter(builder);
    }

    default public void before(Session session) {
    }

    public void process(Session var1, ByteBuf var2, int var3, int var4, boolean var5);

    default public void after(Session session) {
    }

    default public void ensureDefragmented(boolean isLastPart) {
        if (!isLastPart) {
            throw new IllegalStateException("This processor expects defragmented data.");
        }
    }

    public static class ActionBuilderAdapter
    implements Builder {
        private final Action.Builder builder;

        public ActionBuilderAdapter(Action.Builder builder) {
            this.builder = builder;
        }

        @Override
        public Builder copy(Object newParent) {
            return new ActionBuilderAdapter((Action.Builder)this.builder.copy(null));
        }

        @Override
        public Processor build(boolean fragmented) {
            return new ActionAdapter(this.builder.build());
        }
    }

    public static class ActionBuilderConverter
    implements Function<Action.Builder, Builder> {
        @Override
        public Builder apply(Action.Builder builder) {
            return new ActionBuilderAdapter(builder);
        }
    }

    public static class ActionAdapter
    implements Processor {
        private final Action action;

        public ActionAdapter(Action action) {
            this.action = action;
        }

        @Override
        public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
            if (!isLastPart) {
                return;
            }
            this.action.run(session);
        }
    }

    public static abstract class BaseDelegating
    implements Processor {
        protected final Processor delegate;

        protected BaseDelegating(Processor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void before(Session session) {
            this.delegate.before(session);
        }

        @Override
        public void after(Session session) {
            this.delegate.after(session);
        }
    }

    @IncludeBuilders(value={@IncludeBuilders.Conversion(from=Action.Builder.class, adapter=ActionBuilderConverter.class)})
    public static interface Builder
    extends BuilderBase<Builder> {
        public Processor build(boolean var1);
    }
}

