/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.statistics.Statistics;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Request
implements Callable<Void>,
GenericFutureListener<Future<Void>> {
    private static final Logger log = LogManager.getLogger(Request.class);
    private static final GenericFutureListener<Future<Object>> FAILURE_LISTENER = future -> {
        if (!future.isSuccess() && !future.isCancelled()) {
            log.error("Timeout task failed", future.cause());
        }
    };
    public final Session session;
    private long startTimestampMillis;
    private long startTimestampNanos;
    private SequenceInstance sequence;
    private SequenceInstance completionSequence;
    private Statistics statistics;
    private ScheduledFuture<?> timeoutFuture;
    private Connection connection;
    private Status status = Status.IDLE;
    private Result result = Result.VALID;

    public Request(Session session) {
        this.session = session;
    }

    @Override
    public Void call() {
        int uniqueId = this.session == null ? -1 : this.session.uniqueId();
        log.warn("#{} Request timeout, closing connection {}", (Object)uniqueId, (Object)this.connection);
        this.timeoutFuture = null;
        if (this.status != Status.COMPLETED) {
            this.result = Result.TIMED_OUT;
            this.statistics.incrementTimeouts(this.startTimestampMillis);
            if (this.connection == null) {
                log.warn("#{} connection is already null", (Object)uniqueId);
            } else {
                this.connection.close();
            }
        } else {
            log.trace("#{} Request {} is already completed.", (Object)uniqueId, (Object)this);
        }
        return null;
    }

    public void start(SequenceInstance sequence, Statistics statistics) {
        this.startTimestampMillis = System.currentTimeMillis();
        this.startTimestampNanos = System.nanoTime();
        this.sequence = sequence;
        this.completionSequence = sequence.incRefCnt();
        this.statistics = statistics;
        this.status = Status.RUNNING;
        this.result = Result.VALID;
    }

    public void attach(Connection connection) {
        this.connection = connection;
    }

    public Status status() {
        return this.status;
    }

    public boolean isValid() {
        return this.result == Result.VALID;
    }

    public void markInvalid() {
        this.result = Result.INVALID;
    }

    public void setCompleting() {
        this.status = Status.COMPLETING;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETED || this.status == Status.IDLE;
    }

    public void setCompleted() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
        this.connection = null;
        this.sequence = null;
        if (this.status != Status.IDLE) {
            this.status = Status.COMPLETED;
            this.completionSequence.decRefCnt(this.session);
            this.completionSequence = null;
        }
    }

    public Connection connection() {
        return this.connection;
    }

    public SequenceInstance sequence() {
        return this.sequence;
    }

    public Statistics statistics() {
        return this.statistics;
    }

    public void recordResponse(long endTimestampNanos) {
        this.statistics.recordResponse(this.startTimestampMillis, endTimestampNanos - this.startTimestampNanos);
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public long startTimestampNanos() {
        return this.startTimestampNanos;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeoutFuture = this.session.executor().schedule((Callable)this, timeout, timeUnit);
        this.timeoutFuture.addListener(FAILURE_LISTENER);
    }

    public void operationComplete(Future<Void> future) {
        if (!future.isSuccess()) {
            log.error("Failed to write request {} to {}", (Object)this, (Object)this.connection);
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public abstract void release();

    public void enter() {
        this.session.currentSequence(this.sequence);
        this.session.currentRequest(this);
    }

    public void exit() {
        this.session.currentSequence(null);
        this.session.currentRequest(null);
    }

    public void unsafeEnterSequence(SequenceInstance sequence) {
        this.sequence = sequence;
    }

    protected void setIdle() {
        this.status = Status.IDLE;
    }

    public String toString() {
        return "(#" + this.session.uniqueId() + ", " + this.status + ", " + this.result + ")";
    }

    public static enum Status {
        IDLE,
        RUNNING,
        COMPLETING,
        COMPLETED;

    }

    public static enum Result {
        VALID,
        INVALID,
        TIMED_OUT;

    }
}

